/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import refinedstorage.RefinedStorage;
import refinedstorage.RefinedStorageBlocks;
import refinedstorage.block.EnumControllerType;
import refinedstorage.item.ItemBlockBase;

public class ItemBlockController
extends ItemBlockBase {
    public ItemBlockController() {
        super(RefinedStorageBlocks.CONTROLLER, true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.func_77960_j() != EnumControllerType.CREATIVE.getId()) {
            int energyStored = 0;
            int energyCapacity = RefinedStorage.INSTANCE.controllerCapacity;
            if (stack.func_77978_p() != null) {
                if (stack.func_77978_p().func_74764_b("Energy")) {
                    energyStored = stack.func_77978_p().func_74762_e("Energy");
                }
                if (stack.func_77978_p().func_74764_b("EnergyCapacity")) {
                    energyCapacity = stack.func_77978_p().func_74762_e("EnergyCapacity");
                }
            }
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:energy_stored", (Object[])new Object[]{energyStored, energyCapacity}));
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        ItemBlockController.createStackWithNBT(stack);
    }

    public static ItemStack createStackWithNBT(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("Energy", stack.func_77960_j() == EnumControllerType.CREATIVE.getId() ? RefinedStorage.INSTANCE.controllerCapacity : 0);
        return stack;
    }
}

