/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.inventory;

import net.minecraft.tileentity.TileEntity;
import refinedstorage.RefinedStorageItems;
import refinedstorage.inventory.IItemValidator;
import refinedstorage.inventory.ItemHandlerBasic;
import refinedstorage.inventory.ItemValidatorBasic;
import refinedstorage.item.ItemUpgrade;

public class ItemHandlerUpgrade
extends ItemHandlerBasic {
    public ItemHandlerUpgrade(int size, TileEntity tile, int ... supportedUpgrades) {
        super(size, tile, new IItemValidator[supportedUpgrades.length]);
        for (int i = 0; i < supportedUpgrades.length; ++i) {
            this.validators[i] = new ItemValidatorBasic(RefinedStorageItems.UPGRADE, supportedUpgrades[i]);
        }
    }

    public int getSpeed() {
        return this.getSpeed(9, 2);
    }

    public int getSpeed(int speed, int speedIncrease) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot(i).func_77952_i() != 2) continue;
            speed -= speedIncrease;
        }
        return speed;
    }

    public boolean hasUpgrade(int type) {
        return this.getUpgradeCount(type) > 0;
    }

    public int getUpgradeCount(int type) {
        int upgrades = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot(i).func_77952_i() != type) continue;
            ++upgrades;
        }
        return upgrades;
    }

    public int getEnergyUsage() {
        int usage = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i) == null) continue;
            usage += ItemUpgrade.getEnergyUsage(this.getStackInSlot(i).func_77952_i());
        }
        return usage;
    }
}

