/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui.sidebutton;

import net.minecraft.util.text.TextFormatting;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.grid.GuiGrid;
import refinedstorage.gui.sidebutton.SideButton;
import refinedstorage.integration.jei.IntegrationJEI;

public class SideButtonGridSearchBoxMode
extends SideButton {
    private GuiGrid gui;

    public SideButtonGridSearchBoxMode(GuiGrid gui) {
        this.gui = gui;
    }

    @Override
    public String getTooltip(GuiBase gui) {
        return TextFormatting.YELLOW + gui.t("sidebutton.refinedstorage:grid.search_box_mode", new Object[0]) + TextFormatting.RESET + "\n" + gui.t("sidebutton.refinedstorage:grid.search_box_mode." + this.gui.getGrid().getSearchBoxMode(), new Object[0]);
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        gui.bindTexture("icons.png");
        gui.drawTexture(x, y + 2 - 1, 0, 96, 16, 16);
    }

    @Override
    public void actionPerformed() {
        int mode = this.gui.getGrid().getSearchBoxMode();
        if (mode == 0) {
            mode = 1;
        } else if (mode == 1) {
            mode = IntegrationJEI.isLoaded() ? 2 : 0;
        } else if (mode == 2) {
            mode = 3;
        } else if (mode == 3) {
            mode = 0;
        }
        this.gui.getGrid().onSearchBoxModeChanged(mode);
        this.gui.updateSearchFieldFocus(mode);
    }
}

