/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui.sidebutton;

import net.minecraft.util.text.TextFormatting;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.sidebutton.SideButton;
import refinedstorage.tile.data.TileDataManager;
import refinedstorage.tile.data.TileDataParameter;

public class SideButtonCompare
extends SideButton {
    private TileDataParameter<Integer> parameter;
    private int mask;

    public SideButtonCompare(TileDataParameter<Integer> parameter, int mask) {
        this.parameter = parameter;
        this.mask = mask;
    }

    @Override
    public String getTooltip(GuiBase gui) {
        String tooltip = TextFormatting.YELLOW + gui.t("sidebutton.refinedstorage:compare." + this.mask, new Object[0]) + TextFormatting.RESET + "\n";
        tooltip = (this.parameter.getValue() & this.mask) == this.mask ? tooltip + gui.t("gui.yes", new Object[0]) : tooltip + gui.t("gui.no", new Object[0]);
        return tooltip;
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        gui.bindTexture("icons.png");
        int ty = 0;
        if (this.mask == 1) {
            ty = 80;
        } else if (this.mask == 2) {
            ty = 48;
        }
        int tx = (this.parameter.getValue() & this.mask) == this.mask ? 0 : 16;
        gui.drawTexture(x, y + 1, tx, ty, 16, 16);
    }

    @Override
    public void actionPerformed() {
        TileDataManager.setParameter(this.parameter, this.parameter.getValue() ^ this.mask);
    }
}

