/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui.grid;

import com.google.common.primitives.Ints;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import refinedstorage.RefinedStorage;
import refinedstorage.container.ContainerCraftingSettings;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.grid.ClientStack;
import refinedstorage.gui.grid.GuiGrid;
import refinedstorage.network.MessageGridCraftingStart;

public class GuiCraftingSettings
extends GuiBase {
    private static final int DEFAULT_AMOUNT = 1;
    private GuiTextField amountField;
    private GuiGrid gui;
    private ClientStack stack;
    private GuiButton startButton;
    private GuiButton cancelButton;
    private GuiButton[] incrementButtons = new GuiButton[6];

    public GuiCraftingSettings(GuiGrid gui, EntityPlayer player, ClientStack stack) {
        super(new ContainerCraftingSettings(player, stack.getStack()), 172, 99);
        this.gui = gui;
        this.stack = stack;
    }

    @Override
    public void init(int x, int y) {
        int i;
        this.startButton = this.addButton(x + 114, y + 33, 50, 20, this.t("misc.refinedstorage:start", new Object[0]));
        this.cancelButton = this.addButton(x + 114, y + 57, 50, 20, this.t("gui.cancel", new Object[0]));
        this.amountField = new GuiTextField(0, this.field_146289_q, x + 7 + 1, y + 50 + 1, 63, this.field_146289_q.field_78288_b);
        this.amountField.func_146185_a(false);
        this.amountField.func_146189_e(true);
        this.amountField.func_146180_a(String.valueOf(1));
        this.amountField.func_146193_g(0xFFFFFF);
        this.amountField.func_146205_d(false);
        this.amountField.func_146195_b(true);
        int[] increments = new int[]{1, 10, 64, -1, -10, -64};
        for (i = 0; i < 3; ++i) {
            this.incrementButtons[i] = this.addButton(x + 6 + i * 33, y + 20, 30, 20, "+" + increments[i]);
        }
        for (i = 0; i < 3; ++i) {
            this.incrementButtons[3 + i] = this.addButton(x + 6 + i * 33, y + 72, 30, 20, String.valueOf(increments[3 + i]));
        }
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafting_settings.png");
        this.drawTexture(x, y, 0, 0, this.field_146294_l, this.field_146295_m);
        this.amountField.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.t("container.crafting", new Object[0]));
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (this.func_146983_a(keyCode) || !this.amountField.func_146201_a(character, keyCode)) {
            if (keyCode == 28) {
                this.startRequest();
            } else if (keyCode == 1) {
                this.close();
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.startButton.field_146127_k) {
            this.startRequest();
        } else if (button.field_146127_k == this.cancelButton.field_146127_k) {
            this.close();
        } else {
            for (GuiButton incrementButton : this.incrementButtons) {
                if (incrementButton.field_146127_k != button.field_146127_k) continue;
                Integer oldAmount = Ints.tryParse((String)this.amountField.func_146179_b());
                if (oldAmount == null) {
                    oldAmount = 0;
                }
                int newAmount = Integer.parseInt(incrementButton.field_146126_j);
                newAmount = Math.min(Math.max(1, oldAmount + newAmount), 500);
                this.amountField.func_146180_a(String.valueOf(newAmount));
                break;
            }
        }
    }

    private void startRequest() {
        Integer quantity = Ints.tryParse((String)this.amountField.func_146179_b());
        if (quantity != null && quantity > 0 && quantity <= 500) {
            RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingStart(this.stack.getId(), quantity));
            this.close();
        }
    }

    private void close() {
        FMLClientHandler.instance().showGuiScreen((Object)this.gui);
    }
}

