/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui;

import refinedstorage.container.ContainerSolderer;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import refinedstorage.tile.TileSolderer;

public class GuiSolderer
extends GuiBase {
    private TileSolderer solderer;

    public GuiSolderer(ContainerSolderer container, TileSolderer solderer) {
        super(container, 211, 171);
        this.solderer = solderer;
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(TileSolderer.REDSTONE_MODE));
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/solderer.png");
        this.drawTexture(x, y, 0, 0, this.field_146294_l, this.field_146295_m);
        if (this.solderer.isWorking()) {
            this.drawTexture(x + 83, y + 38 - 1, 212, 0, this.getProgressScaled(22), 15);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.t("gui.refinedstorage:solderer", new Object[0]));
        this.drawString(7, 77, this.t("container.inventory", new Object[0]));
        if (this.inBounds(83, 38, 22, 15, mouseX, mouseY) && this.solderer.isWorking()) {
            this.drawTooltip(mouseX, mouseY, this.t("gui.refinedstorage:solderer.progress", this.getProgressScaled(100)));
        }
    }

    private int getProgressScaled(int scale) {
        float duration;
        float progress = TileSolderer.PROGRESS.getValue().intValue();
        if (progress > (duration = (float)TileSolderer.DURATION.getValue().intValue())) {
            return scale;
        }
        return (int)(progress / duration * (float)scale);
    }
}

