/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import refinedstorage.RefinedStorage;
import refinedstorage.container.ContainerCraftingMonitor;
import refinedstorage.gui.GuiBase;
import refinedstorage.gui.Scrollbar;
import refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import refinedstorage.network.MessageCraftingMonitorCancel;
import refinedstorage.tile.ClientCraftingTask;
import refinedstorage.tile.TileCraftingMonitor;

public class GuiCraftingMonitor
extends GuiBase {
    private static final int VISIBLE_ROWS = 3;
    private static final int ITEM_WIDTH = 72;
    private static final int ITEM_HEIGHT = 30;
    private TileCraftingMonitor craftingMonitor;
    private GuiButton cancelButton;
    private GuiButton cancelAllButton;
    private int itemSelected = -1;
    private boolean renderItemSelection;
    private int renderItemSelectionX;
    private int renderItemSelectionY;

    public GuiCraftingMonitor(ContainerCraftingMonitor container, TileCraftingMonitor craftingMonitor) {
        super(container, 176, 230);
        this.setScrollbar(new Scrollbar(157, 20, 12, 89));
        this.craftingMonitor = craftingMonitor;
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(TileCraftingMonitor.REDSTONE_MODE));
        String cancel = this.t("gui.cancel", new Object[0]);
        String cancelAll = this.t("misc.refinedstorage:cancel_all", new Object[0]);
        int cancelButtonWidth = 14 + this.field_146289_q.func_78256_a(cancel);
        int cancelAllButtonWidth = 14 + this.field_146289_q.func_78256_a(cancelAll);
        this.cancelButton = this.addButton(x + 7, y + 113, cancelButtonWidth, 20, cancel, false);
        this.cancelAllButton = this.addButton(x + 7 + cancelButtonWidth + 4, y + 113, cancelAllButtonWidth, 20, cancelAll, false);
    }

    @Override
    public void update(int x, int y) {
        this.getScrollbar().setEnabled(this.getRows() > 3);
        this.getScrollbar().setMaxOffset(this.getRows() - 3);
        if (this.itemSelected >= this.getTasks().size()) {
            this.itemSelected = -1;
        }
        this.cancelButton.field_146124_l = this.itemSelected != -1;
        this.cancelAllButton.field_146124_l = this.getTasks().size() > 0;
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafting_monitor.png");
        this.drawTexture(x, y, 0, 0, this.field_146294_l, this.field_146295_m);
        if (this.renderItemSelection) {
            this.drawTexture(x + this.renderItemSelectionX, y + this.renderItemSelectionY, 178, 0, 72, 30);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.t("gui.refinedstorage:crafting_monitor", new Object[0]));
        this.drawString(7, 137, this.t("container.inventory", new Object[0]));
        int x = 8;
        int y = 20;
        int item = this.getScrollbar().getOffset() * 2;
        RenderHelper.func_74520_c();
        String[] lines = null;
        this.renderItemSelection = false;
        for (int i = 0; i < 6; ++i) {
            if (item < this.getTasks().size()) {
                if (item == this.itemSelected) {
                    this.renderItemSelection = true;
                    this.renderItemSelectionX = x;
                    this.renderItemSelectionY = y;
                }
                ClientCraftingTask task = this.getTasks().get(i);
                this.drawItem(x + 4, y + 11, task.getOutput());
                float scale = 0.5f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.drawString(this.calculateOffsetOnScale(x + 5, scale), this.calculateOffsetOnScale(y + 4, scale), task.getOutput().func_82833_r());
                GlStateManager.func_179121_F();
                if (this.inBounds(x + 5, y + 10, 16, 16, mouseX, mouseY) && !task.getInfo().trim().equals("")) {
                    lines = task.getInfo().split("\n");
                    for (int j = 0; j < lines.length; ++j) {
                        String line = lines[j];
                        if (line.startsWith("T=")) {
                            line = this.t(line.substring(2), new Object[0]);
                        } else if (line.startsWith("I=")) {
                            line = TextFormatting.YELLOW + this.t(line.substring(2), new Object[0]);
                        }
                        lines[j] = line;
                    }
                }
            }
            if (i == 1 || i == 3) {
                x = 8;
                y += 30;
            } else {
                x += 72;
            }
            ++item;
        }
        if (lines != null) {
            this.drawTooltip(mouseX, mouseY, Arrays.asList(lines));
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.getTasks().size() / 2.0f));
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.cancelButton && this.itemSelected != -1) {
            RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(this.craftingMonitor, this.getTasks().get(this.itemSelected).getId()));
        } else if (button == this.cancelAllButton && this.getTasks().size() > 0) {
            RefinedStorage.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(this.craftingMonitor, -1));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.inBounds(8, 20, 144, 90, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            this.itemSelected = -1;
            int item = this.getScrollbar().getOffset() * 2;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 2; ++x) {
                    int ix = 8 + x * 72;
                    int iy = 20 + y * 30;
                    if (this.inBounds(ix, iy, 72, 30, mouseX - this.field_147003_i, mouseY - this.field_147009_r) && item < this.getTasks().size()) {
                        this.itemSelected = item;
                    }
                    ++item;
                }
            }
        }
    }

    private List<ClientCraftingTask> getTasks() {
        return TileCraftingMonitor.TASKS.getValue();
    }
}

