/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import refinedstorage.RefinedStorage;
import refinedstorage.block.BlockCable;
import refinedstorage.block.EnumPlacementType;
import refinedstorage.tile.TileConstructor;

public class BlockConstructor
extends BlockCable {
    public static final AxisAlignedBB HOLDER_NORTH_AABB = BlockConstructor.createAABB(7, 7, 2, 9, 9, 6);
    public static final AxisAlignedBB HOLDER_EAST_AABB = BlockConstructor.createAABB(10, 7, 7, 14, 9, 9);
    public static final AxisAlignedBB HOLDER_SOUTH_AABB = BlockConstructor.createAABB(7, 7, 10, 9, 9, 14);
    public static final AxisAlignedBB HOLDER_WEST_AABB = BlockConstructor.createAABB(2, 7, 7, 6, 9, 9);
    public static final AxisAlignedBB HOLDER_UP_AABB = BlockConstructor.createAABB(7, 10, 7, 9, 14, 9);
    public static final AxisAlignedBB HOLDER_DOWN_AABB = BlockConstructor.createAABB(7, 2, 7, 9, 6, 9);
    public static final AxisAlignedBB HEAD_NORTH_AABB = BlockConstructor.createAABB(0, 0, 0, 16, 16, 2);
    public static final AxisAlignedBB HEAD_EAST_AABB = BlockConstructor.createAABB(14, 0, 0, 16, 16, 16);
    public static final AxisAlignedBB HEAD_SOUTH_AABB = BlockConstructor.createAABB(0, 0, 14, 16, 16, 16);
    public static final AxisAlignedBB HEAD_WEST_AABB = BlockConstructor.createAABB(0, 0, 0, 2, 16, 16);
    public static final AxisAlignedBB HEAD_DOWN_AABB = BlockConstructor.createAABB(0, 0, 0, 16, 2, 16);
    public static final AxisAlignedBB HEAD_UP_AABB = BlockConstructor.createAABB(0, 14, 0, 16, 16, 16);

    public BlockConstructor() {
        super("constructor");
    }

    @Override
    public List<AxisAlignedBB> getNonUnionizedCollisionBoxes(IBlockState state) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
            case NORTH: {
                boxes.add(HOLDER_NORTH_AABB);
                boxes.add(HEAD_NORTH_AABB);
                break;
            }
            case EAST: {
                boxes.add(HOLDER_EAST_AABB);
                boxes.add(HEAD_EAST_AABB);
                break;
            }
            case SOUTH: {
                boxes.add(HOLDER_SOUTH_AABB);
                boxes.add(HEAD_SOUTH_AABB);
                break;
            }
            case WEST: {
                boxes.add(HOLDER_WEST_AABB);
                boxes.add(HEAD_WEST_AABB);
                break;
            }
            case UP: {
                boxes.add(HOLDER_UP_AABB);
                boxes.add(HEAD_UP_AABB);
                break;
            }
            case DOWN: {
                boxes.add(HOLDER_DOWN_AABB);
                boxes.add(HEAD_DOWN_AABB);
            }
        }
        return boxes;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileConstructor();
    }

    public boolean onBlockActivatedDefault(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hitCablePart(state, world, pos, hitX, hitY, hitZ)) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)RefinedStorage.INSTANCE, 8, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public EnumPlacementType getPlacementType() {
        return EnumPlacementType.ANY;
    }
}

