/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcmultipart.block.BlockCoverable;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.INetworkNode;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.block.EnumPlacementType;
import refinedstorage.tile.TileBase;
import refinedstorage.tile.TileCable;
import refinedstorage.tile.TileMultipartNode;
import refinedstorage.tile.TileNode;

public class BlockCable
extends BlockCoverable {
    protected static final PropertyDirection DIRECTION = PropertyDirection.func_177714_a((String)"direction");
    protected static AxisAlignedBB CORE_AABB = BlockCable.createAABB(6, 6, 6, 10, 10, 10);
    protected static AxisAlignedBB NORTH_AABB = BlockCable.createAABB(6, 6, 0, 10, 10, 6);
    protected static AxisAlignedBB EAST_AABB = BlockCable.createAABB(10, 6, 6, 16, 10, 10);
    protected static AxisAlignedBB SOUTH_AABB = BlockCable.createAABB(6, 6, 10, 10, 10, 16);
    protected static AxisAlignedBB WEST_AABB = BlockCable.createAABB(0, 6, 6, 6, 10, 10);
    protected static AxisAlignedBB UP_AABB = BlockCable.createAABB(6, 10, 6, 10, 16, 10);
    protected static AxisAlignedBB DOWN_AABB = BlockCable.createAABB(6, 0, 6, 10, 6, 10);
    protected static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    protected static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    protected static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    protected static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    protected static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private String name;

    protected static AxisAlignedBB createAABB(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return new AxisAlignedBB((double)((float)fromX / 16.0f), (double)((float)fromY / 16.0f), (double)((float)fromZ / 16.0f), (double)((float)toX / 16.0f), (double)((float)toY / 16.0f), (double)((float)toZ / 16.0f));
    }

    public BlockCable(String name) {
        super(Material.field_151576_e);
        this.name = name;
        this.func_149711_c(0.6f);
        this.setRegistryName("refinedstorage", name);
        this.func_149647_a(RefinedStorage.INSTANCE.tab);
    }

    public String func_149739_a() {
        return "block.refinedstorage:" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public BlockCable() {
        this("cable");
    }

    public boolean func_149744_f(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCable();
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{NORTH}).add(new IProperty[]{EAST}).add(new IProperty[]{SOUTH}).add(new IProperty[]{WEST}).add(new IProperty[]{UP}).add(new IProperty[]{DOWN}).add(new IUnlistedProperty[]{BlockMultipartContainer.PROPERTY_MULTIPART_CONTAINER});
        if (this.getPlacementType() != null) {
            builder.add(new IProperty[]{DIRECTION});
        }
        return builder.build();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, EnumFacing.DOWN)));
        if (this.getPlacementType() != null) {
            state = state.func_177226_a((IProperty)DIRECTION, (Comparable)((TileNode)world.func_175625_s(pos)).getDirection());
        }
        return state;
    }

    private boolean hasConnectionWith(IBlockAccess world, BlockPos pos, EnumFacing direction) {
        TileEntity facing = world.func_175625_s(pos.func_177972_a(direction));
        if (facing instanceof INetworkMaster || facing instanceof INetworkNode) {
            if (this.getPlacementType() != null && ((TileMultipartNode)world.func_175625_s(pos)).getFacingTile() == facing) {
                return false;
            }
            return !TileMultipartNode.hasBlockingMicroblock(world, pos, direction) && !TileMultipartNode.hasBlockingMicroblock(world, pos.func_177972_a(direction), direction.func_176734_d());
        }
        return false;
    }

    private boolean isInAABB(AxisAlignedBB aabb, float hitX, float hitY, float hitZ) {
        return (double)hitX >= aabb.field_72340_a && (double)hitX <= aabb.field_72336_d && (double)hitY >= aabb.field_72338_b && (double)hitY <= aabb.field_72337_e && (double)hitZ >= aabb.field_72339_c && (double)hitZ <= aabb.field_72334_f;
    }

    protected boolean hitCablePart(IBlockState state, World world, BlockPos pos, float hitX, float hitY, float hitZ) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        return this.isInAABB(CORE_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)NORTH) != false && this.isInAABB(NORTH_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)EAST) != false && this.isInAABB(EAST_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)SOUTH) != false && this.isInAABB(SOUTH_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)WEST) != false && this.isInAABB(WEST_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)UP) != false && this.isInAABB(UP_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)DOWN) != false && this.isInAABB(DOWN_AABB, hitX, hitY, hitZ);
    }

    public List<AxisAlignedBB> getUnionizedCollisionBoxes(IBlockState state) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.add(CORE_AABB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            boxes.add(NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            boxes.add(EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            boxes.add(SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            boxes.add(WEST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            boxes.add(UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            boxes.add(DOWN_AABB);
        }
        return boxes;
    }

    public List<AxisAlignedBB> getNonUnionizedCollisionBoxes(IBlockState state) {
        return Collections.emptyList();
    }

    public List<AxisAlignedBB> getCollisionBoxes(IBlockState state) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.addAll(this.getUnionizedCollisionBoxes(state));
        boxes.addAll(this.getNonUnionizedCollisionBoxes(state));
        return boxes;
    }

    public void addCollisionBoxToListDefault(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        for (AxisAlignedBB aabb : this.getCollisionBoxes(this.func_176221_a(state, (IBlockAccess)world, pos))) {
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    public RayTraceResult collisionRayTraceDefault(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceUtils.AdvancedRayTraceResult result = RayTraceUtils.collisionRayTrace((World)world, (BlockPos)pos, (Vec3d)start, (Vec3d)end, this.getCollisionBoxes(this.func_176221_a(state, (IBlockAccess)world, pos)));
        return result != null ? result.hit : null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected EnumPlacementType getPlacementType() {
        return null;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase entity) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, entity);
        if (this.getPlacementType() != null) {
            return state.func_177226_a((IProperty)DIRECTION, (Comparable)this.getPlacementType().getFrom(facing, pos, entity));
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        if (this.getPlacementType() != null) {
            ((TileBase)world.func_175625_s(pos)).setDirection((EnumFacing)state.func_177229_b((IProperty)DIRECTION));
        }
        this.attemptConnect(world, pos);
    }

    public void attemptConnect(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
                if (!(tile instanceof TileNode) || !((TileNode)tile).isConnected()) continue;
                NetworkUtils.rebuildGraph(((TileNode)tile).getNetwork());
                break;
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        INetworkMaster network = null;
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileNode) {
                network = ((TileNode)tile).getNetwork();
            }
            if (tile instanceof TileBase && ((TileBase)tile).getDrops() != null) {
                IItemHandler handler = ((TileBase)tile).getDrops();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (handler.getStackInSlot(i) == null) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
                }
            }
        }
        super.func_180663_b(world, pos, state);
        if (network != null) {
            NetworkUtils.rebuildGraph(network);
        }
    }

    public List<ItemStack> getDropsDefault(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this, 1, this.func_176201_c(state)));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase && ((TileBase)tile).getDrops() != null) {
            IItemHandler handler = ((TileBase)tile).getDrops();
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i) == null) continue;
                drops.add(handler.getStackInSlot(i));
            }
        }
        return drops;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (!world.field_72995_K && this.getPlacementType() != null) {
            TileBase tile = (TileBase)world.func_175625_s(pos);
            tile.setDirection(this.getPlacementType().getNext(tile.getDirection()));
            tile.updateBlock();
            return true;
        }
        return false;
    }
}

