/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import refinedstorage.RefinedStorage;
import refinedstorage.block.EnumPlacementType;
import refinedstorage.item.ItemBlockBase;
import refinedstorage.tile.TileBase;

public abstract class BlockBase
extends Block {
    private static final PropertyDirection DIRECTION = PropertyDirection.func_177714_a((String)"direction");
    private String name;

    public BlockBase(String name) {
        super(Material.field_151576_e);
        this.name = name;
        this.func_149711_c(1.9f);
        this.setRegistryName("refinedstorage", name);
        this.func_149647_a(RefinedStorage.INSTANCE.tab);
    }

    public String func_149739_a() {
        return "block.refinedstorage:" + this.name;
    }

    protected BlockStateContainer.Builder createBlockStateBuilder() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        if (this.getPlacementType() != null) {
            builder.add(new IProperty[]{DIRECTION});
        }
        return builder;
    }

    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().build();
    }

    public Item createItem() {
        return new ItemBlockBase(this, false);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getPlacementType() != null) {
            return state.func_177226_a((IProperty)DIRECTION, (Comparable)((TileBase)world.func_175625_s(pos)).getDirection());
        }
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (!world.field_72995_K && this.getPlacementType() != null) {
            TileBase tile = (TileBase)world.func_175625_s(pos);
            tile.setDirection(this.getPlacementType().getNext(tile.getDirection()));
            tile.updateBlock();
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase entity) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, entity);
        if (this.getPlacementType() != null) {
            return state.func_177226_a((IProperty)DIRECTION, (Comparable)this.getPlacementType().getFrom(facing, pos, entity));
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        if (this.getPlacementType() != null) {
            ((TileBase)world.func_175625_s(pos)).setDirection((EnumFacing)state.func_177229_b((IProperty)DIRECTION));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase && ((TileBase)tile).getDrops() != null) {
            IItemHandler handler = ((TileBase)tile).getDrops();
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i) == null) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest ? true : super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    protected EnumPlacementType getPlacementType() {
        return EnumPlacementType.HORIZONTAL;
    }
}

