/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import refinedstorage.api.network.INetworkNode;
import refinedstorage.api.network.INetworkNodeGraph;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.tile.TileController;
import refinedstorage.tile.TileNetworkTransmitter;

public class NetworkNodeGraph
implements INetworkNodeGraph {
    private TileController controller;
    private List<INetworkNode> nodes = new ArrayList<INetworkNode>();
    private Set<Integer> nodeHashes = new HashSet<Integer>();

    public NetworkNodeGraph(TileController controller) {
        this.controller = controller;
    }

    @Override
    public void rebuild(BlockPos start, boolean notify) {
        BlockPos currentPos;
        if (!this.controller.canRun()) {
            if (!this.nodes.isEmpty()) {
                this.disconnectAll();
            }
            return;
        }
        World world = this.getWorld();
        ArrayList<INetworkNode> newNodes = new ArrayList<INetworkNode>();
        HashSet<Integer> newNodeHashes = new HashSet<Integer>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toCheck = new ArrayDeque<BlockPos>();
        checked.add(start);
        toCheck.add(start);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos pos = start.func_177972_a(facing);
            checked.add(pos);
            toCheck.add(pos);
        }
        while ((currentPos = (BlockPos)toCheck.poll()) != null) {
            Object transmitter;
            TileEntity tile = world.func_175625_s(currentPos);
            if (tile instanceof TileController && !this.controller.func_174877_v().equals((Object)tile.func_174877_v())) {
                world.func_72876_a(null, (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), 4.5f, true);
            }
            if (!(tile instanceof INetworkNode)) continue;
            INetworkNode node = (INetworkNode)tile;
            newNodes.add(node);
            newNodeHashes.add(NetworkUtils.getNodeHashCode(world, node));
            if (tile instanceof TileNetworkTransmitter && ((TileNetworkTransmitter)(transmitter = (TileNetworkTransmitter)tile)).canTransmit()) {
                if (!((TileNetworkTransmitter)transmitter).isSameDimension()) {
                    NetworkNodeGraph dimensionGraph = new NetworkNodeGraph(this.controller, (TileNetworkTransmitter)transmitter){
                        final /* synthetic */ TileNetworkTransmitter val$transmitter;
                        {
                            this.val$transmitter = tileNetworkTransmitter;
                            super(controller);
                        }

                        @Override
                        public World getWorld() {
                            return DimensionManager.getWorld((int)this.val$transmitter.getReceiverDimension());
                        }
                    };
                    dimensionGraph.rebuild(((TileNetworkTransmitter)transmitter).getReceiver(), false);
                    newNodes.addAll(dimensionGraph.all());
                    newNodeHashes.addAll(dimensionGraph.allHashes());
                } else {
                    BlockPos receiver = ((TileNetworkTransmitter)transmitter).getReceiver();
                    if (checked.add(receiver)) {
                        toCheck.add(receiver);
                    }
                }
            }
            transmitter = EnumFacing.field_82609_l;
            int n = ((EnumFacing[])transmitter).length;
            for (int i = 0; i < n; ++i) {
                BlockPos pos;
                Object facing = transmitter[i];
                if (!node.canConduct((EnumFacing)facing) || !checked.add(pos = currentPos.func_177972_a((EnumFacing)facing))) continue;
                toCheck.add(pos);
            }
        }
        ArrayList<INetworkNode> oldNodes = new ArrayList<INetworkNode>(this.nodes);
        HashSet<Integer> oldNodeHashes = new HashSet<Integer>(this.nodeHashes);
        this.nodes = newNodes;
        this.nodeHashes = newNodeHashes;
        if (notify) {
            boolean changed = false;
            for (INetworkNode newNode : this.nodes) {
                if (oldNodeHashes.contains(NetworkUtils.getNodeHashCode(newNode.getNodeWorld(), newNode))) continue;
                newNode.onConnected(this.controller);
                changed = true;
            }
            for (INetworkNode oldNode : oldNodes) {
                if (this.nodeHashes.contains(NetworkUtils.getNodeHashCode(oldNode.getNodeWorld(), oldNode))) continue;
                oldNode.onDisconnected(this.controller);
                changed = true;
            }
            if (changed) {
                this.controller.getDataManager().sendParameterToWatchers(TileController.NODES);
            }
        }
    }

    @Override
    public List<INetworkNode> all() {
        return this.nodes;
    }

    @Override
    public Set<Integer> allHashes() {
        return this.nodeHashes;
    }

    @Override
    public void disconnectAll() {
        for (INetworkNode node : this.nodes) {
            if (!node.isConnected()) continue;
            node.onDisconnected(this.controller);
        }
        this.nodes.clear();
        this.nodeHashes.clear();
        this.controller.getDataManager().sendParameterToWatchers(TileController.NODES);
    }

    public World getWorld() {
        return this.controller.func_145831_w();
    }
}

