/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.network.grid.IItemGridHandler;
import refinedstorage.api.storage.CompareUtils;

public class ItemGridHandler
implements IItemGridHandler {
    public static final int MAX_CRAFTING_PER_REQUEST = 500;
    private INetworkMaster network;

    public ItemGridHandler(INetworkMaster network) {
        this.network = network;
    }

    @Override
    public void onExtract(int hash, int flags, EntityPlayerMP player) {
        ItemStack took;
        ItemStack item = this.network.getItemStorage().get(hash);
        if (item == null) {
            return;
        }
        int itemSize = item.field_77994_a;
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? held != null && (!CompareUtils.compareStackNoQuantity(item, held) || held.field_77994_a + 1 > held.func_77976_d()) : player.field_71071_by.func_70445_o() != null) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > 32) {
                size = 32;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        if ((took = NetworkUtils.extractItem(this.network, item, size = Math.min(size, item.func_77973_b().getItemStackLimit(item)))) != null) {
            if ((flags & 4) == 4) {
                if (!player.field_71071_by.func_70441_a(took.func_77946_l())) {
                    InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)took);
                }
            } else {
                if (single && held != null) {
                    ++held.field_77994_a;
                } else {
                    player.field_71071_by.func_70437_b(took);
                }
                player.func_71113_k();
            }
            this.network.getWirelessGridHandler().drainEnergy((EntityPlayer)player, 3);
        }
    }

    @Override
    public ItemStack onInsert(ItemStack stack) {
        return this.network.insertItem(stack, stack.field_77994_a, false);
    }

    @Override
    public void onInsertHeldItem(boolean single, EntityPlayerMP player) {
        int size;
        if (player.field_71071_by.func_70445_o() == null) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int n = size = single ? 1 : stack.field_77994_a;
        if (single) {
            if (this.network.insertItem(stack, size, true) == null) {
                this.network.insertItem(stack, size, false);
                stack.field_77994_a -= size;
                if (stack.field_77994_a == 0) {
                    player.field_71071_by.func_70437_b(null);
                }
            }
        } else {
            player.field_71071_by.func_70437_b(this.network.insertItem(stack, size, false));
        }
        player.func_71113_k();
        this.network.getWirelessGridHandler().drainEnergy((EntityPlayer)player, 3);
    }

    @Override
    public void onCraftingRequested(int hash, int quantity) {
        if (quantity <= 0 || quantity > 500) {
            return;
        }
        ItemStack stack = this.network.getItemStorage().get(hash);
        if (stack == null) {
            return;
        }
        int quantityPerRequest = 0;
        ICraftingPattern pattern = NetworkUtils.getPattern(this.network, stack);
        if (pattern != null) {
            for (ItemStack output : pattern.getOutputs()) {
                if (!CompareUtils.compareStackNoQuantity(stack, output)) continue;
                quantityPerRequest += output.field_77994_a;
                if (!pattern.isProcessing()) break;
            }
            while (quantity > 0) {
                this.network.addCraftingTaskAsLast(this.network.createCraftingTask(pattern));
                quantity -= quantityPerRequest;
            }
        }
    }

    @Override
    public void onCraftingCancelRequested(int id) {
        if (id >= 0 && id < this.network.getCraftingTasks().size()) {
            this.network.cancelCraftingTask(this.network.getCraftingTasks().get(id));
        } else if (id == -1) {
            for (ICraftingTask task : this.network.getCraftingTasks()) {
                this.network.cancelCraftingTask(task);
            }
        }
    }
}

