/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.autocrafting;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.api.autocrafting.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.api.storage.CompareUtils;
import refinedstorage.apiimpl.autocrafting.BasicCraftingTask;

public class ProcessingCraftingTask
implements ICraftingTask {
    public static final int ID = 1;
    private static final String NBT_INSERTED = "Inserted";
    private static final String NBT_CHILD_TASKS = "ChildTasks";
    private static final String NBT_SATISFIED = "Satisfied";
    private ICraftingPattern pattern;
    private boolean[] inserted;
    private boolean[] childTasks;
    private boolean[] satisfied;
    private boolean updatedOnce;

    public ProcessingCraftingTask(ICraftingPattern pattern) {
        this.pattern = pattern;
        this.inserted = new boolean[pattern.getInputs().length];
        this.childTasks = new boolean[pattern.getInputs().length];
        this.satisfied = new boolean[pattern.getOutputs().length];
    }

    public ProcessingCraftingTask(NBTTagCompound tag, ICraftingPattern pattern) {
        this.pattern = pattern;
        this.inserted = BasicCraftingTask.readBooleanArray(tag, NBT_INSERTED);
        this.childTasks = BasicCraftingTask.readBooleanArray(tag, NBT_CHILD_TASKS);
        this.satisfied = BasicCraftingTask.readBooleanArray(tag, NBT_SATISFIED);
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean update(World world, INetworkMaster network) {
        int i;
        this.updatedOnce = true;
        ICraftingPatternContainer container = this.pattern.getContainer(world);
        if (container.getConnectedItems() != null) {
            for (i = 0; i < this.inserted.length; ++i) {
                if (this.inserted[i]) continue;
                ItemStack input = this.pattern.getInputs()[i];
                ItemStack took = NetworkUtils.extractItem(network, input, 1);
                if (took != null) {
                    if (ItemHandlerHelper.insertItem((IItemHandler)container.getConnectedItems(), (ItemStack)took, (boolean)true) == null) {
                        ItemHandlerHelper.insertItem((IItemHandler)container.getConnectedItems(), (ItemStack)took, (boolean)false);
                        this.inserted[i] = true;
                        continue;
                    }
                    network.insertItem(took, took.field_77994_a, false);
                    continue;
                }
                if (!this.childTasks[i]) {
                    ICraftingPattern pattern = NetworkUtils.getPattern(network, input);
                    if (pattern == null) continue;
                    this.childTasks[i] = true;
                    network.addCraftingTask(network.createCraftingTask(pattern));
                }
                break;
            }
        } else {
            return true;
        }
        for (i = 0; i < this.satisfied.length; ++i) {
            if (this.satisfied[i]) continue;
            return false;
        }
        return true;
    }

    public boolean onInserted(ItemStack stack) {
        for (int i = 0; i < this.pattern.getOutputs().length; ++i) {
            if (this.satisfied[i] || !CompareUtils.compareStackNoQuantity(stack, this.pattern.getOutputs()[i])) continue;
            this.satisfied[i] = true;
            return true;
        }
        return false;
    }

    @Override
    public void onDone(INetworkMaster network) {
    }

    @Override
    public void onCancelled(INetworkMaster network) {
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound patternTag = new NBTTagCompound();
        this.pattern.writeToNBT(patternTag);
        tag.func_74782_a("Pattern", (NBTBase)patternTag);
        BasicCraftingTask.writeBooleanArray(tag, NBT_INSERTED, this.inserted);
        BasicCraftingTask.writeBooleanArray(tag, NBT_CHILD_TASKS, this.childTasks);
        BasicCraftingTask.writeBooleanArray(tag, NBT_SATISFIED, this.satisfied);
        tag.func_74768_a("Type", 1);
    }

    @Override
    public String getInfo() {
        if (!this.updatedOnce) {
            return "T=gui.refinedstorage:crafting_monitor.not_started_yet";
        }
        StringBuilder builder = new StringBuilder();
        boolean hasMissingItems = false;
        for (int i = 0; i < this.pattern.getInputs().length; ++i) {
            ItemStack input = this.pattern.getInputs()[i];
            if (this.inserted[i] || this.childTasks[i]) continue;
            if (!hasMissingItems) {
                builder.append("I=gui.refinedstorage:crafting_monitor.missing_items\n");
                hasMissingItems = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        boolean areItemsCrafting = false;
        for (int i = 0; i < this.pattern.getInputs().length; ++i) {
            ItemStack input = this.pattern.getInputs()[i];
            if (this.inserted[i] || !this.childTasks[i]) continue;
            if (!areItemsCrafting) {
                builder.append("I=gui.refinedstorage:crafting_monitor.items_crafting\n");
                areItemsCrafting = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        boolean areItemsProcessing = false;
        for (int i = 0; i < this.pattern.getInputs().length; ++i) {
            ItemStack input = this.pattern.getInputs()[i];
            if (!this.inserted[i]) continue;
            if (!areItemsProcessing) {
                builder.append("I=gui.refinedstorage:crafting_monitor.items_processing\n");
                areItemsProcessing = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        return builder.toString();
    }
}

