/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.autocrafting;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.storage.CompareUtils;

public class CraftingTaskScheduler {
    private static final String NBT_SCHEDULED = "CraftingTaskScheduled";
    private TileEntity tile;
    private ItemStack scheduledItem;

    public CraftingTaskScheduler(TileEntity tile) {
        this.tile = tile;
    }

    public boolean canSchedule(int compare, ItemStack item) {
        return this.scheduledItem == null || !CompareUtils.compareStack(this.scheduledItem, item, compare);
    }

    public void schedule(INetworkMaster network, int compare, ItemStack item) {
        ICraftingPattern pattern = network.getPattern(item, compare);
        if (pattern != null) {
            this.scheduledItem = item;
            network.addCraftingTaskAsLast(network.createCraftingTask(pattern));
            this.tile.func_70296_d();
        }
    }

    public void resetSchedule() {
        this.scheduledItem = null;
        this.tile.func_70296_d();
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.scheduledItem != null) {
            tag.func_74782_a(NBT_SCHEDULED, (NBTBase)this.scheduledItem.serializeNBT());
        } else {
            tag.func_82580_o(NBT_SCHEDULED);
        }
    }

    public void read(NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_SCHEDULED)) {
            this.scheduledItem = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(NBT_SCHEDULED));
        }
    }
}

