/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.autocrafting;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingPatternContainer;
import refinedstorage.tile.TileCrafter;

public class CraftingPattern
implements ICraftingPattern {
    public static final String NBT = "Pattern";
    private static final String NBT_CRAFTER_X = "CrafterX";
    private static final String NBT_CRAFTER_Y = "CrafterY";
    private static final String NBT_CRAFTER_Z = "CrafterZ";
    private BlockPos crafterPos;
    private TileCrafter crafter;
    private boolean processing;
    private ItemStack[] inputs;
    private ItemStack[] outputs;
    private ItemStack[] byproducts;

    public CraftingPattern(BlockPos crafterPos, boolean processing, ItemStack[] inputs, ItemStack[] outputs, ItemStack[] byproducts) {
        this.crafterPos = crafterPos;
        this.processing = processing;
        this.inputs = inputs;
        this.outputs = outputs;
        this.byproducts = byproducts;
    }

    @Override
    public ICraftingPatternContainer getContainer(World world) {
        if (this.crafter == null) {
            this.crafter = (TileCrafter)world.func_175625_s(this.crafterPos);
        }
        return this.crafter;
    }

    @Override
    public BlockPos getContainerPosition() {
        return this.crafterPos;
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public ItemStack[] getInputs() {
        return this.inputs;
    }

    @Override
    public ItemStack[] getOutputs() {
        return this.outputs;
    }

    @Override
    public ItemStack[] getByproducts() {
        return this.byproducts;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("Processing", this.processing);
        NBTTagList inputsTag = new NBTTagList();
        for (ItemStack input : this.inputs) {
            inputsTag.func_74742_a((NBTBase)input.serializeNBT());
        }
        tag.func_74782_a("Inputs", (NBTBase)inputsTag);
        NBTTagList outputsTag = new NBTTagList();
        for (ItemStack output : this.outputs) {
            outputsTag.func_74742_a((NBTBase)output.serializeNBT());
        }
        tag.func_74782_a("Outputs", (NBTBase)outputsTag);
        if (this.byproducts != null) {
            NBTTagList byproductsTag = new NBTTagList();
            for (ItemStack byproduct : this.byproducts) {
                byproductsTag.func_74742_a((NBTBase)byproduct.serializeNBT());
            }
            tag.func_74782_a("Byproducts", (NBTBase)byproductsTag);
        }
        tag.func_74768_a(NBT_CRAFTER_X, this.crafterPos.func_177958_n());
        tag.func_74768_a(NBT_CRAFTER_Y, this.crafterPos.func_177956_o());
        tag.func_74768_a(NBT_CRAFTER_Z, this.crafterPos.func_177952_p());
        return tag;
    }

    public static CraftingPattern readFromNBT(NBTTagCompound tag) {
        BlockPos crafterPos = new BlockPos(tag.func_74762_e(NBT_CRAFTER_X), tag.func_74762_e(NBT_CRAFTER_Y), tag.func_74762_e(NBT_CRAFTER_Z));
        boolean processing = tag.func_74767_n("Processing");
        NBTTagList inputsTag = tag.func_150295_c("Inputs", 10);
        ItemStack[] inputs = new ItemStack[inputsTag.func_74745_c()];
        for (int i = 0; i < inputsTag.func_74745_c(); ++i) {
            inputs[i] = ItemStack.func_77949_a((NBTTagCompound)inputsTag.func_150305_b(i));
            if (inputs[i] != null) continue;
            return null;
        }
        NBTTagList outputsTag = tag.func_150295_c("Outputs", 10);
        ItemStack[] outputs = new ItemStack[outputsTag.func_74745_c()];
        for (int i = 0; i < outputsTag.func_74745_c(); ++i) {
            outputs[i] = ItemStack.func_77949_a((NBTTagCompound)outputsTag.func_150305_b(i));
            if (outputs[i] != null) continue;
            return null;
        }
        ItemStack[] byproducts = new ItemStack[]{};
        if (tag.func_74764_b("Byproducts")) {
            NBTTagList byproductsTag = tag.func_150295_c("Byproducts", 10);
            byproducts = new ItemStack[byproductsTag.func_74745_c()];
            for (int i = 0; i < byproductsTag.func_74745_c(); ++i) {
                byproducts[i] = ItemStack.func_77949_a((NBTTagCompound)byproductsTag.func_150305_b(i));
                if (byproducts[i] != null) continue;
                return null;
            }
        }
        return new CraftingPattern(crafterPos, processing, inputs, outputs, byproducts);
    }
}

