/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.apiimpl.autocrafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;

public class BasicCraftingTask
implements ICraftingTask {
    public static final int ID = 0;
    private static final String NBT_SATISFIED = "Satisfied";
    private static final String NBT_CHECKED = "Checked";
    private static final String NBT_CHILD_TASKS = "ChildTasks";
    private static final String NBT_TOOK = "Took";
    private ICraftingPattern pattern;
    private boolean[] satisfied;
    private boolean[] checked;
    private boolean[] childTasks;
    private List<ItemStack> itemsTook = new ArrayList<ItemStack>();
    private boolean updatedOnce;

    public BasicCraftingTask(ICraftingPattern pattern) {
        this.pattern = pattern;
        this.satisfied = new boolean[pattern.getInputs().length];
        this.checked = new boolean[pattern.getInputs().length];
        this.childTasks = new boolean[pattern.getInputs().length];
    }

    public BasicCraftingTask(NBTTagCompound tag, ICraftingPattern pattern) {
        this.pattern = pattern;
        this.satisfied = BasicCraftingTask.readBooleanArray(tag, NBT_SATISFIED);
        this.checked = BasicCraftingTask.readBooleanArray(tag, NBT_CHECKED);
        this.childTasks = BasicCraftingTask.readBooleanArray(tag, NBT_CHILD_TASKS);
        NBTTagList tookList = tag.func_150295_c(NBT_TOOK, 10);
        for (int i = 0; i < tookList.func_74745_c(); ++i) {
            this.itemsTook.add(ItemStack.func_77949_a((NBTTagCompound)tookList.func_150305_b(i)));
        }
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean update(World world, INetworkMaster network) {
        this.updatedOnce = true;
        boolean done = true;
        for (int i = 0; i < this.pattern.getInputs().length; ++i) {
            ICraftingPattern pattern;
            this.checked[i] = true;
            ItemStack input = this.pattern.getInputs()[i];
            if (this.satisfied[i]) continue;
            done = false;
            ItemStack took = NetworkUtils.extractItem(network, input, 1);
            if (took != null) {
                this.itemsTook.add(took);
                this.satisfied[i] = true;
                continue;
            }
            if (this.childTasks[i] || (pattern = NetworkUtils.getPattern(network, input)) == null) break;
            network.addCraftingTask(network.createCraftingTask(pattern));
            this.childTasks[i] = true;
            break;
        }
        return done;
    }

    @Override
    public void onDone(INetworkMaster network) {
        for (ItemStack output : this.pattern.getOutputs()) {
            network.insertItem(output, output.field_77994_a, false);
        }
        if (this.pattern.getByproducts() != null) {
            for (ItemStack byproduct : this.pattern.getByproducts()) {
                network.insertItem(byproduct, byproduct.field_77994_a, false);
            }
        }
    }

    @Override
    public void onCancelled(INetworkMaster network) {
        for (ItemStack took : this.itemsTook) {
            network.insertItem(took, took.field_77994_a, false);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound patternTag = new NBTTagCompound();
        this.pattern.writeToNBT(patternTag);
        tag.func_74782_a("Pattern", (NBTBase)patternTag);
        BasicCraftingTask.writeBooleanArray(tag, NBT_SATISFIED, this.satisfied);
        BasicCraftingTask.writeBooleanArray(tag, NBT_CHECKED, this.checked);
        BasicCraftingTask.writeBooleanArray(tag, NBT_CHILD_TASKS, this.childTasks);
        NBTTagList tookList = new NBTTagList();
        for (ItemStack took : this.itemsTook) {
            tookList.func_74742_a((NBTBase)took.serializeNBT());
        }
        tag.func_74782_a(NBT_TOOK, (NBTBase)tookList);
        tag.func_74768_a("Type", 0);
    }

    @Override
    public String getInfo() {
        if (!this.updatedOnce) {
            return "T=gui.refinedstorage:crafting_monitor.not_started_yet";
        }
        StringBuilder builder = new StringBuilder();
        boolean hasMissingItems = false;
        for (int i = 0; i < this.pattern.getInputs().length; ++i) {
            ItemStack input = this.pattern.getInputs()[i];
            if (!this.checked[i] || this.satisfied[i] || this.childTasks[i]) continue;
            if (!hasMissingItems) {
                builder.append("I=gui.refinedstorage:crafting_monitor.missing_items\n");
                hasMissingItems = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        boolean areItemsCrafting = false;
        for (int i = 0; i < this.pattern.getInputs().length; ++i) {
            ItemStack input = this.pattern.getInputs()[i];
            if (this.satisfied[i] || !this.childTasks[i]) continue;
            if (!areItemsCrafting) {
                builder.append("I=gui.refinedstorage:crafting_monitor.items_crafting\n");
                areItemsCrafting = true;
            }
            builder.append("T=").append(input.func_77977_a()).append(".name\n");
        }
        return builder.toString();
    }

    public static void writeBooleanArray(NBTTagCompound tag, String name, boolean[] array) {
        int[] intArray = new int[array.length];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = array[i] ? 1 : 0;
        }
        tag.func_74782_a(name, (NBTBase)new NBTTagIntArray(intArray));
    }

    public static boolean[] readBooleanArray(NBTTagCompound tag, String name) {
        int[] intArray = tag.func_74759_k(name);
        boolean[] array = new boolean[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            array[i] = intArray[i] == 1;
        }
        return array;
    }
}

