/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcmultipart.MCMultiPartMod;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.client.multipart.ICustomHighlightPart;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.PartState;
import mcmultipart.property.PropertyMultipartStates;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BlockMultipartContainer
extends Block
implements ITileEntityProvider {
    private AxisAlignedBB bounds = field_185505_j;
    private TileMultipartContainer brokenTile = null;
    public static final IProperty<Boolean> PROPERTY_TICKING = PropertyBool.func_177716_a((String)"ticking");
    public static final IUnlistedProperty<List<PartState>> PROPERTY_MULTIPART_CONTAINER = new PropertyMultipartStates("multipart_container");
    static final IProperty<?>[] PROPERTIES = new IProperty[]{PROPERTY_TICKING};
    static final IUnlistedProperty<?>[] UNLISTED_PROPERTIES = new IUnlistedProperty[]{PROPERTY_MULTIPART_CONTAINER};

    public BlockMultipartContainer() {
        super(Material.field_151578_c);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_180632_j(this.func_176223_P().func_177226_a(PROPERTY_TICKING, (Comparable)Boolean.valueOf(true)));
    }

    private TileMultipartContainer getMultipartTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileMultipartContainer ? (TileMultipartContainer)tile : null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return meta == 1 ? new TileMultipartContainer() : new TileMultipartContainer.Ticking();
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        if (state == null || world == null || pos == null || start == null || end == null) {
            return null;
        }
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return null;
        }
        RayTraceUtils.AdvancedRayTraceResultPart result = tile.getPartContainer().collisionRayTrace(start, end);
        if (result == null) {
            return null;
        }
        this.bounds = result.bounds;
        return result.hit;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return this.bounds.func_186670_a(pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity collidingEntity) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        AxisAlignedBB box = entityBox.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        tile.getPartContainer().addCollisionBoxes(box, list, collidingEntity);
        for (AxisAlignedBB aabb : list) {
            collidingBoxes.add(aabb.func_186670_a(pos));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return 0;
        }
        return tile.getPartContainer().getLightValue();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (target instanceof PartMOP) {
            TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
            if (tile == null) {
                return null;
            }
            return tile.getPartContainer().getPickBlock(player, (PartMOP)target);
        }
        return null;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        this.brokenTile = te instanceof TileMultipartContainer ? (TileMultipartContainer)te : null;
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.brokenTile = null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileMultipartContainer brokenTile = this.getMultipartTile(world, pos);
        if (brokenTile == null) {
            brokenTile = this.brokenTile;
        }
        if (brokenTile == null) {
            return Collections.emptyList();
        }
        return brokenTile.getPartContainer().getDrops();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        PartMOP hit = this.reTrace(world, pos, player);
        if (hit == null) {
            return false;
        }
        return tile.getPartContainer().harvest(player, hit) ? super.removedByPlayer(state, world, pos, player, willHarvest) : false;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return 0.0f;
        }
        PartMOP hit = this.reTrace(world, pos, player);
        if (hit == null) {
            return 0.0f;
        }
        return tile.getPartContainer().getHardness(player, hit);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().onActivated(player, hand, heldItem, this.reTrace(world, pos, player));
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onClicked(player, this.reTrace(world, pos, player));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onNeighborBlockChange(neighborBlock);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onNeighborTileChange(EnumFacing.func_176737_a((float)(neighbor.func_177958_n() - pos.func_177958_n()), (float)(neighbor.func_177956_o() - pos.func_177956_o()), (float)(neighbor.func_177952_p() - pos.func_177952_p())));
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onEntityStanding(entity);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        tile.getPartContainer().onEntityCollided(entity);
    }

    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB aabb, Material material) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile == null) {
            return null;
        }
        return tile.getPartContainer().isAABBInsideMaterial(aabb, material);
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, double yToTest, Material material, boolean testingHead) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return null;
        }
        return tile.getPartContainer().isEntityInsideMaterial(entity, yToTest, material, testingHead);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return false;
        }
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().canConnectRedstone(side.func_176734_d());
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return 0;
        }
        return tile.getPartContainer().getWeakSignal(side.func_176734_d());
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return 0;
        }
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return 0;
        }
        return tile.getPartContainer().getStrongSignal(side.func_176734_d());
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().isSideSolid(side);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        if (tile == null) {
            return false;
        }
        return tile.getPartContainer().canPlaceTorchOnTop();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileMultipartContainer tile = this.getMultipartTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.getPartContainer().randomDisplayTick(rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager particleManager) {
        PartMOP hit = this.reTrace(world, pos, MCMultiPartMod.proxy.getPlayer());
        if (hit != null) {
            TextureAtlasSprite icon;
            IBakedModel model;
            if (hit.partHit.addDestroyEffects(AdvancedParticleManager.getInstance(particleManager))) {
                return true;
            }
            ResourceLocation path = hit.partHit.getModelPath();
            IBlockState state = hit.partHit.getExtendedState(MultipartRegistry.getDefaultState(hit.partHit).func_177621_b());
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation(path, MultipartStateMapper.instance.func_178131_a((Map<IProperty<?>, Comparable<?>>)state.func_177228_b())));
            if (model != null && (icon = model.func_177554_e()) != null) {
                AdvancedParticleManager.getInstance(particleManager).addBlockDestroyEffects(pos, icon);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager particleManager) {
        PartMOP hit;
        PartMOP partMOP = hit = target instanceof PartMOP ? (PartMOP)target : null;
        if (hit != null) {
            TextureAtlasSprite icon;
            IBakedModel model;
            if (hit.partHit.addHitEffects(hit, AdvancedParticleManager.getInstance(particleManager))) {
                return true;
            }
            ResourceLocation path = hit.partHit.getModelPath();
            IBlockState partState = hit.partHit.getExtendedState(MultipartRegistry.getDefaultState(hit.partHit).func_177621_b());
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation(path, MultipartStateMapper.instance.func_178131_a((Map<IProperty<?>, Comparable<?>>)partState.func_177228_b())));
            if (model != null && (icon = model.func_177554_e()) != null) {
                AdvancedParticleManager.getInstance(particleManager).addBlockHitEffects(target.func_178782_a(), hit, this.bounds, icon);
            }
        }
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    private PartMOP reTrace(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = RayTraceUtils.getStart(player);
        Vec3d end = RayTraceUtils.getEnd(player);
        RayTraceUtils.AdvancedRayTraceResultPart result = this.getMultipartTile((IBlockAccess)world, pos).getPartContainer().collisionRayTrace(start, end);
        return result == null ? null : (PartMOP)result.hit;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public IExtendedBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartContainer tile = this.getMultipartTile(world, pos);
        return ((IExtendedBlockState)state).withProperty(PROPERTY_MULTIPART_CONTAINER, tile != null ? tile.getPartContainer().getExtendedStates(world, pos) : new ArrayList());
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b(PROPERTY_TICKING) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PROPERTY_TICKING, (Comparable)Boolean.valueOf(meta == 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, PROPERTIES, UNLISTED_PROPERTIES);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public final void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        PartMOP hit;
        PartMOP partMOP = hit = event.getTarget() instanceof PartMOP ? (PartMOP)event.getTarget() : null;
        if (hit != null && hit.partHit instanceof ICustomHighlightPart) {
            GlStateManager.func_179094_E();
            BlockPos pos = hit.func_178782_a();
            EntityPlayer player = event.getPlayer();
            float partialTicks = event.getPartialTicks();
            double x = (double)pos.func_177958_n() - (player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks);
            double y = (double)pos.func_177956_o() - (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks);
            double z = (double)pos.func_177952_p() - (player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            if (((ICustomHighlightPart)hit.partHit).drawHighlight(hit, player, partialTicks)) {
                event.setCanceled(true);
            }
            GlStateManager.func_179121_F();
        }
    }
}

