/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public abstract class TileEntityElectricMachine<RECIPE extends BasicMachineRecipe<RECIPE>>
extends TileEntityBasicMachine<ItemStackInput, ItemStackOutput, RECIPE>
implements ITierUpgradeable {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityElectricMachine(String soundPath, String name, double perTick, int ticksRequired, double maxEnergy) {
        super(soundPath, name, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBasicMachine.png"), perTick, ticksRequired, maxEnergy);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{3, 1, 0, 0, 0, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = new ItemStack[4];
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        if (upgradeTier != Tier.BaseTier.BASIC) {
            return false;
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock.func_176203_a(5), 3);
        TileEntityFactory factory = (TileEntityFactory)this.field_145850_b.func_175625_s(this.func_174877_v());
        IFactory.RecipeType type = IFactory.RecipeType.getFromMachine(this.func_145838_q(), this.func_145832_p());
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        factory.soundURL = this.soundURL;
        factory.progress[0] = this.operatingTicks;
        factory.clientActive = this.clientActive;
        factory.isActive = this.isActive;
        factory.updateDelay = this.updateDelay;
        factory.controlType = this.controlType;
        factory.prevEnergy = this.prevEnergy;
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.upgradeComponent.setUpgradeSlot(0);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        factory.recipeType = type;
        factory.upgradeComponent.setSupported(Upgrade.GAS, type.fuelEnergyUpgrades());
        factory.securityComponent.readFrom(this.securityComponent);
        for (TransmissionType transmission : this.configComponent.transmissions) {
            factory.configComponent.setConfig(transmission, this.configComponent.getConfig(transmission));
            factory.configComponent.setEjecting(transmission, this.configComponent.isEjecting(transmission));
        }
        factory.inventory[5] = this.inventory[0];
        factory.inventory[1] = this.inventory[1];
        factory.inventory[8] = this.inventory[2];
        factory.inventory[0] = this.inventory[3];
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(1, this);
            MachineRecipe recipe = this.getRecipe();
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.electricityStored -= this.energyPerTick;
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else if (this.operatingTicks + 1 >= this.ticksRequired) {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate((RECIPE)recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 3) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 0) {
            return RecipeHandler.isInRecipe(itemstack, this.getRecipes());
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public ItemStackInput getInput() {
        return new ItemStackInput(this.inventory[0]);
    }

    @Override
    public RECIPE getRecipe() {
        ItemStackInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ItemStackInput)((BasicMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getRecipe(input, this.getRecipes());
        }
        return (RECIPE)((BasicMachineRecipe)this.cachedRecipe);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((BasicMachineRecipe)recipe).operate(this.inventory, 0, 2);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((BasicMachineRecipe)recipe).canOperate(this.inventory, 0, 2);
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate((RECIPE)this.getRecipe())};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 6: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }
}

