/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalCrystallizer
extends TileEntityNoisyElectricBlock
implements IGasHandler,
ITubeConnection,
IRedstoneControl,
ISideConfiguration,
IUpgradeTile,
ISustainedData,
ITankManager,
IConfigCardAccess,
ISecurityTile {
    public static final int MAX_GAS = 10000;
    public GasTank inputTank = new GasTank(10000);
    public int updateDelay;
    public int operatingTicks;
    public int BASE_TICKS_REQUIRED = 200;
    public int ticksRequired = 200;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double BASE_ENERGY_USAGE = MekanismConfig.usage.chemicalCrystallizerUsage;
    public double energyUsage = MekanismConfig.usage.chemicalCrystallizerUsage;
    public CrystallizerRecipe cachedRecipe;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);
    public TileComponentSecurity securityComponent;

    public TileEntityChemicalCrystallizer() {
        super("machine.crystallizer", "ChemicalCrystallizer", BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER.baseEnergy);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Gas", EnumColor.PURPLE, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 3, 0, 0, 1, 2});
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.YELLOW, new int[]{0}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{-1, -1, -1, -1, 1, -1});
        this.configComponent.setCanEject(TransmissionType.GAS, false);
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = new ItemStack[4];
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            CrystallizerRecipe recipe;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(2, this);
            if (this.inventory[0] != null && (this.inputTank.getGas() == null || this.inputTank.getStored() < this.inputTank.getMaxGas())) {
                this.inputTank.receive(GasTransmission.removeGas(this.inventory[0], this.inputTank.getGasType(), this.inputTank.getNeeded()), true);
            }
            if (this.canOperate(recipe = this.getRecipe()) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyUsage) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyUsage);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    public CrystallizerRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalCrystallizerRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public boolean canOperate(CrystallizerRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.inventory);
    }

    public void operate(CrystallizerRecipe recipe) {
        recipe.operate(this.inputTank, this.inventory);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            this.operatingTicks = dataStream.readInt();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (dataStream.readBoolean()) {
                this.inputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.inputTank.setGas(null);
            }
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.operatingTicks);
        data.add(this.controlType.ordinal());
        if (this.inputTank.getGas() != null) {
            data.add(true);
            data.add(this.inputTank.getGas().getGas().getID());
            data.add(this.inputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inputTank.read(nbtTags.func_74775_l("rightTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("rightTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74757_a("sideDataStored", true);
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0) && this.inputTank.canReceive(type) && RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(type);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.inputTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas());
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        if (slotID == 1) {
            return true;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyUsage = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                break;
            }
            case ENERGY: {
                this.energyUsage = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                break;
            }
        }
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

