/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiDigitalMiner;
import mekanism.client.gui.GuiDigitalMinerConfig;
import mekanism.client.gui.GuiMFilterSelect;
import mekanism.client.gui.GuiMItemStackFilter;
import mekanism.client.gui.GuiMMaterialFilter;
import mekanism.client.gui.GuiMModIDFilter;
import mekanism.client.gui.GuiMOreDictFilter;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerDigitalMiner;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityDigitalMiner;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketDigitalMinerGui
implements IMessageHandler<DigitalMinerGuiMessage, IMessage> {
    public IMessage onMessage(final DigitalMinerGuiMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Thread(){

            @Override
            public void run() {
                if (!player.field_70170_p.field_72995_K) {
                    WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
                    if (worldServer != null && message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityDigitalMiner) {
                        DigitalMinerGuiMessage.openServerGui(message.packetType, message.guiType, (World)worldServer, (EntityPlayerMP)player, message.coord4D, message.index);
                    }
                } else if (message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p) instanceof TileEntityDigitalMiner) {
                    try {
                        if (message.packetType == MinerGuiPacket.CLIENT) {
                            FMLCommonHandler.instance().showGuiScreen((Object)DigitalMinerGuiMessage.getGui(message.packetType, message.guiType, player, player.field_70170_p, message.coord4D.getPos(), -1));
                        } else if (message.packetType == MinerGuiPacket.CLIENT_INDEX) {
                            FMLCommonHandler.instance().showGuiScreen((Object)DigitalMinerGuiMessage.getGui(message.packetType, message.guiType, player, player.field_70170_p, message.coord4D.getPos(), message.index));
                        }
                        player.field_71070_bA.field_75152_c = message.windowId;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, player);
        return null;
    }

    public static enum MinerGuiPacket {
        SERVER,
        CLIENT,
        SERVER_INDEX,
        CLIENT_INDEX;

    }

    public static class DigitalMinerGuiMessage
    implements IMessage {
        public Coord4D coord4D;
        public MinerGuiPacket packetType;
        public int guiType;
        public int windowId = -1;
        public int index = -1;

        public DigitalMinerGuiMessage() {
        }

        public DigitalMinerGuiMessage(MinerGuiPacket type, Coord4D coord, int guiID, int extra, int extra2) {
            this.packetType = type;
            this.coord4D = coord;
            this.guiType = guiID;
            if (this.packetType == MinerGuiPacket.CLIENT) {
                this.windowId = extra;
            } else if (this.packetType == MinerGuiPacket.SERVER_INDEX) {
                this.index = extra;
            } else if (this.packetType == MinerGuiPacket.CLIENT_INDEX) {
                this.windowId = extra;
                this.index = extra2;
            }
        }

        public static void openServerGui(MinerGuiPacket t, int guiType, World world, EntityPlayerMP playerMP, Coord4D obj, int i) {
            Container container = null;
            playerMP.func_71128_l();
            switch (guiType) {
                case 0: {
                    container = new ContainerNull((EntityPlayer)playerMP, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
                    break;
                }
                case 4: {
                    container = new ContainerDigitalMiner(playerMP.field_71071_by, (TileEntityDigitalMiner)obj.getTileEntity((IBlockAccess)world));
                    break;
                }
                case 5: {
                    container = new ContainerNull((EntityPlayer)playerMP, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
                    break;
                }
                default: {
                    container = new ContainerFilter(playerMP.field_71071_by, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
                }
            }
            playerMP.func_71117_bO();
            int window = playerMP.field_71139_cq;
            if (t == MinerGuiPacket.SERVER) {
                Mekanism.packetHandler.sendTo(new DigitalMinerGuiMessage(MinerGuiPacket.CLIENT, obj, guiType, window, 0), playerMP);
            } else if (t == MinerGuiPacket.SERVER_INDEX) {
                Mekanism.packetHandler.sendTo(new DigitalMinerGuiMessage(MinerGuiPacket.CLIENT_INDEX, obj, guiType, window, i), playerMP);
            }
            playerMP.field_71070_bA = container;
            playerMP.field_71070_bA.field_75152_c = window;
            playerMP.field_71070_bA.func_75132_a((IContainerListener)playerMP);
            if (guiType == 0) {
                TileEntityDigitalMiner tile = (TileEntityDigitalMiner)obj.getTileEntity((IBlockAccess)world);
                for (EntityPlayer player : tile.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(obj, tile.getFilterPacket(new ArrayList<Object>())), (EntityPlayerMP)player);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static GuiScreen getGui(MinerGuiPacket packetType, int type, EntityPlayer player, World world, BlockPos pos, int index) {
            if (type == 0) {
                return new GuiDigitalMinerConfig(player, (TileEntityDigitalMiner)world.func_175625_s(pos));
            }
            if (type == 4) {
                return new GuiDigitalMiner(player.field_71071_by, (TileEntityDigitalMiner)world.func_175625_s(pos));
            }
            if (type == 5) {
                return new GuiMFilterSelect(player, (TileEntityDigitalMiner)world.func_175625_s(pos));
            }
            if (packetType == MinerGuiPacket.CLIENT) {
                if (type == 1) {
                    return new GuiMItemStackFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos));
                }
                if (type == 2) {
                    return new GuiMOreDictFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos));
                }
                if (type == 3) {
                    return new GuiMMaterialFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos));
                }
                if (type == 6) {
                    return new GuiMModIDFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos));
                }
            } else if (packetType == MinerGuiPacket.CLIENT_INDEX) {
                if (type == 1) {
                    return new GuiMItemStackFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos), index);
                }
                if (type == 2) {
                    return new GuiMOreDictFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos), index);
                }
                if (type == 3) {
                    return new GuiMMaterialFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos), index);
                }
                if (type == 6) {
                    return new GuiMModIDFilter(player, (TileEntityDigitalMiner)world.func_175625_s(pos), index);
                }
            }
            return null;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            this.coord4D.write(dataStream);
            dataStream.writeInt(this.guiType);
            if (this.packetType == MinerGuiPacket.CLIENT || this.packetType == MinerGuiPacket.CLIENT_INDEX) {
                dataStream.writeInt(this.windowId);
            }
            if (this.packetType == MinerGuiPacket.SERVER_INDEX || this.packetType == MinerGuiPacket.CLIENT_INDEX) {
                dataStream.writeInt(this.index);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = MinerGuiPacket.values()[dataStream.readInt()];
            this.coord4D = Coord4D.read(dataStream);
            this.guiType = dataStream.readInt();
            if (this.packetType == MinerGuiPacket.CLIENT || this.packetType == MinerGuiPacket.CLIENT_INDEX) {
                this.windowId = dataStream.readInt();
            }
            if (this.packetType == MinerGuiPacket.SERVER_INDEX || this.packetType == MinerGuiPacket.CLIENT_INDEX) {
                this.index = dataStream.readInt();
            }
        }
    }
}

