/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.ITileNetwork;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityMultiblock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDataRequest
implements IMessageHandler<DataRequestMessage, IMessage> {
    public IMessage onMessage(final DataRequestMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Thread(){

            @Override
            public void run() {
                WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
                TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)worldServer);
                if (worldServer != null) {
                    if (tileEntity instanceof TileEntityMultiblock) {
                        ((TileEntityMultiblock)tileEntity).sendStructure = true;
                    }
                    if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null)) {
                        IGridTransmitter transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null);
                        transmitter.setRequestsUpdate();
                        if (transmitter.hasTransmitterNetwork()) {
                            ((DynamicNetwork)transmitter.getTransmitterNetwork()).addUpdate(player);
                        }
                    }
                    if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TILE_NETWORK_CAPABILITY, null)) {
                        ITileNetwork network = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.TILE_NETWORK_CAPABILITY, null);
                        Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), network.getNetworkedData(new ArrayList<Object>())), (EntityPlayerMP)player);
                    }
                }
            }
        }, player);
        return null;
    }

    public static class DataRequestMessage
    implements IMessage {
        public Coord4D coord4D;

        public DataRequestMessage() {
        }

        public DataRequestMessage(Coord4D coord) {
            this.coord4D = coord;
        }

        public void toBytes(ByteBuf dataStream) {
            this.coord4D.write(dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = Coord4D.read(dataStream);
        }
    }
}

