/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITileNetwork;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConfigurationUpdate
implements IMessageHandler<ConfigurationUpdateMessage, IMessage> {
    public IMessage onMessage(final ConfigurationUpdateMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Thread(){

            @Override
            public void run() {
                TileEntity tile = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                ITileNetwork network = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.TILE_NETWORK_CAPABILITY, null);
                if (tile instanceof ISideConfiguration) {
                    ISideConfiguration config = (ISideConfiguration)tile;
                    if (message.packetType == ConfigurationPacket.EJECT) {
                        config.getConfig().setEjecting(message.transmission, !config.getConfig().isEjecting(message.transmission));
                    } else if (message.packetType == ConfigurationPacket.SIDE_DATA) {
                        if (message.clickType == 0) {
                            MekanismUtils.incrementOutput((ISideConfiguration)tile, message.transmission, message.configIndex);
                        } else if (message.clickType == 1) {
                            MekanismUtils.decrementOutput((ISideConfiguration)tile, message.transmission, message.configIndex);
                        } else if (message.clickType == 2) {
                            ((ISideConfiguration)tile).getConfig().getConfig((TransmissionType)message.transmission)[message.configIndex.ordinal()] = 0;
                        }
                        tile.func_70296_d();
                        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(message.coord4D, network.getNetworkedData(new ArrayList<Object>())), new Range4D(message.coord4D));
                    } else if (message.packetType == ConfigurationPacket.EJECT_COLOR) {
                        if (message.clickType == 0) {
                            config.getEjector().setOutputColor(TransporterUtils.increment(config.getEjector().getOutputColor()));
                        } else if (message.clickType == 1) {
                            config.getEjector().setOutputColor(TransporterUtils.decrement(config.getEjector().getOutputColor()));
                        } else if (message.clickType == 2) {
                            config.getEjector().setOutputColor(null);
                        }
                    } else if (message.packetType == ConfigurationPacket.INPUT_COLOR) {
                        EnumFacing side = EnumFacing.func_82600_a((int)message.inputSide);
                        if (message.clickType == 0) {
                            config.getEjector().setInputColor(side, TransporterUtils.increment(config.getEjector().getInputColor(side)));
                        } else if (message.clickType == 1) {
                            config.getEjector().setInputColor(side, TransporterUtils.decrement(config.getEjector().getInputColor(side)));
                        } else if (message.clickType == 2) {
                            config.getEjector().setInputColor(side, null);
                        }
                    } else if (message.packetType == ConfigurationPacket.STRICT_INPUT) {
                        config.getEjector().setStrictInput(!config.getEjector().hasStrictInput());
                    }
                    for (EntityPlayer p : ((TileEntityBasicBlock)((Object)config)).playersUsing) {
                        Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(message.coord4D, network.getNetworkedData(new ArrayList<Object>())), (EntityPlayerMP)p);
                    }
                }
            }
        }, player);
        return null;
    }

    public static enum ConfigurationPacket {
        EJECT,
        SIDE_DATA,
        EJECT_COLOR,
        INPUT_COLOR,
        STRICT_INPUT;

    }

    public static class ConfigurationUpdateMessage
    implements IMessage {
        public Coord4D coord4D;
        public EnumFacing configIndex;
        public int inputSide;
        public TransmissionType transmission;
        public int clickType;
        public ConfigurationPacket packetType;

        public ConfigurationUpdateMessage() {
        }

        public ConfigurationUpdateMessage(ConfigurationPacket type, Coord4D coord, int click, int extra, TransmissionType trans) {
            this.packetType = type;
            this.coord4D = coord;
            if (this.packetType == ConfigurationPacket.EJECT) {
                this.transmission = trans;
            }
            if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
                this.clickType = click;
            }
            if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                this.clickType = click;
                this.configIndex = EnumFacing.func_82600_a((int)extra);
                this.transmission = trans;
            }
            if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                this.clickType = click;
                this.inputSide = extra;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            this.coord4D.write(dataStream);
            if (this.packetType != ConfigurationPacket.EJECT && this.packetType != ConfigurationPacket.STRICT_INPUT) {
                dataStream.writeInt(this.clickType);
            }
            if (this.packetType == ConfigurationPacket.EJECT) {
                dataStream.writeInt(this.transmission.ordinal());
            }
            if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                dataStream.writeInt(this.configIndex.ordinal());
                dataStream.writeInt(this.transmission.ordinal());
            }
            if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                dataStream.writeInt(this.inputSide);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = ConfigurationPacket.values()[dataStream.readInt()];
            this.coord4D = Coord4D.read(dataStream);
            if (this.packetType == ConfigurationPacket.EJECT) {
                this.transmission = TransmissionType.values()[dataStream.readInt()];
            } else if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                this.clickType = dataStream.readInt();
                this.configIndex = EnumFacing.func_82600_a((int)dataStream.readInt());
                this.transmission = TransmissionType.values()[dataStream.readInt()];
            } else if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
                this.clickType = dataStream.readInt();
            } else if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                this.clickType = dataStream.readInt();
                this.inputSide = dataStream.readInt();
            }
        }
    }
}

