/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.ColourRGBA;
import mekanism.common.HeatNetwork;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.HeatUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PartThermodynamicConductor
extends PartTransmitter<IHeatTransfer, HeatNetwork>
implements IHeatTransfer {
    public Tier.ConductorTier tier;
    public double temperature = 0.0;
    public double clientTemperature = 0.0;
    public double heatToAbsorb = 0.0;

    public PartThermodynamicConductor(Tier.ConductorTier conductorTier) {
        this.tier = conductorTier;
    }

    @Override
    public HeatNetwork createNewNetwork() {
        return new HeatNetwork();
    }

    @Override
    public HeatNetwork createNetworkByMerging(Collection networks) {
        return new HeatNetwork(networks);
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Object getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public void updateShare() {
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, EnumFacing side) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            IHeatTransfer transfer = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
            return transfer.canConnectHeat(side.func_176734_d());
        }
        return false;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.HEAT;
    }

    public ResourceLocation getType() {
        return new ResourceLocation("mekanism:thermodynamic_conductor_" + this.tier.name().toLowerCase());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        this.temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.func_74780_a("temperature", this.temperature);
        return nbtTags;
    }

    public void sendTemp() {
        Coord4D coord = new Coord4D(this.getPos(), this.getWorld());
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(coord, this.getNetworkedData(new ArrayList<Object>())), new Range4D(coord));
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        this.temperature = dataStream.readDouble();
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        data.add(this.temperature);
        return data;
    }

    @Override
    public void writeUpdatePacket(PacketBuffer packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeUpdatePacket(packet);
    }

    @Override
    public void readUpdatePacket(PacketBuffer packet) {
        this.tier = Tier.ConductorTier.values()[packet.readInt()];
        super.readUpdatePacket(packet);
    }

    public ColourRGBA getBaseColour() {
        return this.tier.baseColour;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return this.tier.inverseConduction;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return this.tier.inverseConductionInsulation;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.tier.inverseHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        if (Math.abs(this.temperature - this.clientTemperature) > this.temperature / 100.0) {
            this.clientTemperature = this.temperature;
            this.sendTemp();
        }
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return true;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj;
        if (PartThermodynamicConductor.connectionMapContainsSide(this.getAllCurrentConnections(), side) && CapabilityUtils.hasCapability((ICapabilityProvider)(adj = this.getWorld().func_175625_s(this.getPos().func_177972_a(side))), Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.ConductorTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }
}

