/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import java.util.Collection;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.Tier;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PartPressurizedTube
extends PartTransmitter<IGasHandler, GasNetwork>
implements IGasHandler {
    public Tier.TubeTier tier = Tier.TubeTier.BASIC;
    public float currentScale;
    public GasTank buffer = new GasTank(this.getCapacity());
    public GasStack lastWrite;

    public PartPressurizedTube(Tier.TubeTier tubeTier) {
        this.tier = tubeTier;
    }

    @Override
    public void func_73660_a() {
        if (!this.getWorld().field_72995_K) {
            this.updateShare();
            IGasHandler[] connectedAcceptors = GasTransmission.getConnectedAcceptors(this.getPos(), this.getWorld());
            for (EnumFacing side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                GasStack received;
                IGasHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drawGas(side.func_176734_d(), this.tier.tubePullAmount, false)) == null || received.amount == 0) continue;
                container.drawGas(side.func_176734_d(), this.takeGas(received, true), true);
            }
        } else {
            float targetScale;
            float f = targetScale = this.getTransmitter().hasTransmitterNetwork() ? ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).gasScale : (float)this.buffer.getStored() / (float)this.buffer.getMaxGas();
            if ((double)Math.abs(this.currentScale - targetScale) > 0.01) {
                this.currentScale = (9.0f * this.currentScale + targetScale) / 10.0f;
            }
        }
        super.func_73660_a();
    }

    @Override
    public void updateShare() {
        GasStack last;
        if (this.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().getTransmitterNetworkSize() > 0 && ((last = this.getSaveShare()) != null && (this.lastWrite == null || this.lastWrite.amount != last.amount || this.lastWrite.getGas() != last.getGas()) || last == null && this.lastWrite != null)) {
            this.lastWrite = last;
            this.markDirty();
        }
    }

    private GasStack getSaveShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            int remain = ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount % ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size();
            int toSave = ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount / ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size();
            if (((IGridTransmitter)((GasNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.iterator().next()).equals(this.getTransmitter())) {
                toSave += remain;
            }
            return new GasStack(((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.getGas(), toSave);
        }
        return null;
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().field_72995_K && this.getTransmitter().hasTransmitterNetwork() && this.lastWrite != null && ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount <= 0) {
                ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer = null;
            }
        }
        super.onUnloaded();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.TubeTier.values()[nbtTags.func_74762_e("tier")];
        }
        this.buffer.setMaxGas(this.getCapacity());
        if (nbtTags.func_74764_b("cacheGas")) {
            this.buffer.setGas(GasStack.readFromNBT(nbtTags.func_74775_l("cacheGas")));
        } else {
            this.buffer.setGas(null);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        if (this.lastWrite != null && this.lastWrite.amount > 0) {
            nbtTags.func_74782_a("cacheGas", (NBTBase)this.lastWrite.write(new NBTTagCompound()));
        } else {
            nbtTags.func_82580_o("cacheGas");
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    public ResourceLocation getType() {
        return new ResourceLocation("mekanism:pressurized_tube_" + this.tier.name().toLowerCase());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, EnumFacing side) {
        return GasTransmission.isValidAcceptorOnSide(tile, side);
    }

    @Override
    public GasNetwork createNewNetwork() {
        return new GasNetwork();
    }

    @Override
    public GasNetwork createNetworkByMerging(Collection<GasNetwork> networks) {
        return new GasNetwork(networks);
    }

    @Override
    public int getCapacity() {
        return this.tier.tubeCapacity;
    }

    @Override
    public GasStack getBuffer() {
        return this.buffer == null ? null : this.buffer.getGas();
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null && this.lastWrite != null) {
            ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            this.buffer.setGas(this.lastWrite);
        }
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL) {
            return this.takeGas(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    public int takeGas(GasStack gasStack, boolean doEmit) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).emit(gasStack, doEmit);
        }
        return this.buffer.receive(gasStack, doEmit);
    }

    @Override
    public IGasHandler getCachedAcceptor(EnumFacing side) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)this.cachedAcceptors[side.ordinal()], Capabilities.GAS_HANDLER_CAPABILITY, side.func_176734_d())) {
            return (IGasHandler)super.getCachedAcceptor(side);
        }
        return null;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.TubeTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void readUpdatePacket(PacketBuffer packet) {
        this.tier = Tier.TubeTier.values()[packet.readInt()];
        super.readUpdatePacket(packet);
    }

    @Override
    public void writeUpdatePacket(PacketBuffer packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeUpdatePacket(packet);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }
}

