/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import java.util.Collection;
import mcmultipart.multipart.IMultipartContainer;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.transmitters.Transmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MultipartTransmitter<A, N extends DynamicNetwork<A, N>>
extends Transmitter<A, N> {
    public PartTransmitter<A, N> containingPart;

    public MultipartTransmitter(PartTransmitter<A, N> multiPart) {
        this.setPart(multiPart);
    }

    @Override
    public int getCapacity() {
        return this.getPart().getCapacity();
    }

    @Override
    public World world() {
        return this.getPart().getWorld();
    }

    @Override
    public Coord4D coord() {
        return new Coord4D(this.getPart().getPos(), this.getPart().getWorld());
    }

    @Override
    public Coord4D getAdjacentConnectableTransmitterCoord(EnumFacing side) {
        IGridTransmitter transmitter;
        Coord4D sideCoord = this.coord().offset(side);
        TileEntity potentialTransmitterTile = sideCoord.getTileEntity((IBlockAccess)this.world());
        if (!this.containingPart.canConnectMutual(side)) {
            return null;
        }
        if (CapabilityUtils.hasCapability((ICapabilityProvider)potentialTransmitterTile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) && TransmissionType.checkTransmissionType(transmitter = CapabilityUtils.getCapability((ICapabilityProvider)potentialTransmitterTile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()), this.getTransmissionType()) && this.containingPart.isValidTransmitter(potentialTransmitterTile)) {
            return sideCoord;
        }
        return null;
    }

    @Override
    public A getAcceptor(EnumFacing side) {
        return this.getPart().getCachedAcceptor(side);
    }

    @Override
    public boolean isValid() {
        IMultipartContainer cont = this.getPart().getContainer();
        if (cont == null) {
            return false;
        }
        if (cont instanceof TileEntity && ((TileEntity)cont).func_145837_r()) {
            return false;
        }
        return !this.getPart().unloaded && this.coord().exists(this.world());
    }

    @Override
    public N createEmptyNetwork() {
        return this.getPart().createNewNetwork();
    }

    @Override
    public N getExternalNetwork(Coord4D from) {
        TileEntity tile = from.getTileEntity((IBlockAccess)this.world());
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null)) {
            IGridTransmitter transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null);
            if (TransmissionType.checkTransmissionType(transmitter, this.getTransmissionType())) {
                // empty if block
            }
            return transmitter.getTransmitterNetwork();
        }
        return null;
    }

    @Override
    public void takeShare() {
        this.containingPart.takeShare();
    }

    @Override
    public void updateShare() {
        this.containingPart.updateShare();
    }

    @Override
    public Object getBuffer() {
        return this.getPart().getBuffer();
    }

    @Override
    public N mergeNetworks(Collection<N> toMerge) {
        return this.getPart().createNetworkByMerging(toMerge);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return this.getPart().getTransmissionType();
    }

    @Override
    public void setRequestsUpdate() {
        this.containingPart.sendDesc = true;
    }

    public PartTransmitter<A, N> getPart() {
        return this.containingPart;
    }

    public void setPart(PartTransmitter<A, N> containingPart) {
        this.containingPart = containingPart;
    }
}

