/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IMekWrench;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemEnergized;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft")})
public class ItemConfigurator
extends ItemEnergized
implements IMekWrench,
IToolWrench,
IToolHammer {
    public final int ENERGY_PER_CONFIGURE = 400;
    public final int ENERGY_PER_ITEM_DUMP = 8;
    private Random random = new Random();

    public ItemConfigurator() {
        super(60000.0);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add((Object)((Object)EnumColor.PINK) + LangUtils.localize("gui.state") + ": " + (Object)((Object)this.getColor(this.getState(itemstack))) + this.getStateDisplay(this.getState(itemstack)));
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            Block block = world.func_180495_p(pos).func_177230_c();
            TileEntity tile = world.func_175625_s(pos);
            if (this.getState(stack).isConfigurating()) {
                if (tile instanceof ISideConfiguration && ((ISideConfiguration)tile).getConfig().supports(this.getState(stack).getTransmission())) {
                    ISideConfiguration config = (ISideConfiguration)tile;
                    SideData initial = config.getConfig().getOutput(this.getState(stack).getTransmission(), side, config.getOrientation());
                    if (initial != TileComponentConfig.EMPTY) {
                        if (!player.func_70093_af()) {
                            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + this.getViewModeText(this.getState(stack).getTransmission()) + ": " + (Object)((Object)initial.color) + initial.localize() + " (" + initial.color.getColoredName() + ")"));
                        } else if (this.getEnergy(stack) >= 400.0) {
                            if (SecurityUtils.canAccess(player, tile)) {
                                this.setEnergy(stack, this.getEnergy(stack) - 400.0);
                                MekanismUtils.incrementOutput(config, this.getState(stack).getTransmission(), MekanismUtils.getBaseOrientation(side, config.getOrientation()));
                                SideData data = config.getConfig().getOutput(this.getState(stack).getTransmission(), side, config.getOrientation());
                                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + this.getToggleModeText(this.getState(stack).getTransmission()) + ": " + (Object)((Object)data.color) + data.localize() + " (" + data.color.getColoredName() + ")"));
                                if (config instanceof TileEntityBasicBlock) {
                                    TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)((Object)config);
                                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(tileEntity)));
                                }
                            } else {
                                SecurityUtils.displayNoAccess(player);
                            }
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE_CAPABILITY, side)) {
                    IConfigurable config = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE_CAPABILITY, side);
                    if (SecurityUtils.canAccess(player, tile)) {
                        if (player.func_70093_af()) {
                            return config.onSneakRightClick(player, side);
                        }
                        return config.onRightClick(player, side);
                    }
                    SecurityUtils.displayNoAccess(player);
                    return EnumActionResult.SUCCESS;
                }
            } else if (this.getState(stack) == ConfiguratorMode.EMPTY) {
                if (tile instanceof TileEntityContainerBlock) {
                    IInventory inv = (IInventory)tile;
                    if (SecurityUtils.canAccess(player, tile)) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack slotStack = inv.func_70301_a(i);
                            if (slotStack == null) continue;
                            if (this.getEnergy(stack) < 8.0) break;
                            float xRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            float yRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            float zRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            while (slotStack.field_77994_a > 0) {
                                int j = this.random.nextInt(21) + 10;
                                if (j > slotStack.field_77994_a) {
                                    j = slotStack.field_77994_a;
                                }
                                slotStack.field_77994_a -= j;
                                EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + xRandom), (double)((float)pos.func_177956_o() + yRandom), (double)((float)pos.func_177952_p() + zRandom), new ItemStack(slotStack.func_77973_b(), j, slotStack.func_77952_i()));
                                if (slotStack.func_77942_o()) {
                                    item.func_92059_d().func_77982_d(slotStack.func_77978_p().func_74737_b());
                                }
                                float k = 0.05f;
                                item.field_70159_w = this.random.nextGaussian() * (double)k;
                                item.field_70181_x = this.random.nextGaussian() * (double)k + (double)0.2f;
                                item.field_70179_y = this.random.nextGaussian() * (double)k;
                                world.func_72838_d((Entity)item);
                                inv.func_70299_a(i, null);
                                this.setEnergy(stack, this.getEnergy(stack) - 8.0);
                            }
                        }
                        return EnumActionResult.SUCCESS;
                    }
                    SecurityUtils.displayNoAccess(player);
                    return EnumActionResult.FAIL;
                }
            } else {
                if (this.getState(stack) == ConfiguratorMode.ROTATE) {
                    List<EnumFacing> l = Arrays.asList(block.getValidRotations(world, pos));
                    if (!player.func_70093_af() && l.contains(side)) {
                        block.rotateBlock(world, pos, side);
                    } else if (player.func_70093_af() && l.contains(side.func_176734_d())) {
                        block.rotateBlock(world, pos, side.func_176734_d());
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (this.getState(stack) == ConfiguratorMode.WRENCH) {
                    return EnumActionResult.PASS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public String getViewModeText(TransmissionType type) {
        String base = LangUtils.localize("tooltip.configurator.viewMode");
        return String.format(base, type.localize().toLowerCase());
    }

    public String getToggleModeText(TransmissionType type) {
        String base = LangUtils.localize("tooltip.configurator.toggleMode");
        return String.format(base, type.localize());
    }

    public String getStateDisplay(ConfiguratorMode mode) {
        return mode.getName();
    }

    public EnumColor getColor(ConfiguratorMode mode) {
        return mode.getColor();
    }

    public void setState(ItemStack itemstack, ConfiguratorMode state) {
        ItemDataUtils.setInt(itemstack, "state", state.ordinal());
    }

    public ConfiguratorMode getState(ItemStack itemstack) {
        return ConfiguratorMode.values()[ItemDataUtils.getInt(itemstack, "state")];
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="BuildCraft")
    public boolean canWrench(EntityPlayer player, BlockPos pos) {
        return this.canUseWrench(player.field_71071_by.func_70448_g(), player, pos);
    }

    @Optional.Method(modid="BuildCraft")
    public void wrenchUsed(EntityPlayer player, BlockPos pos) {
    }

    public boolean canWrench(EntityPlayer player, Entity entity) {
        return false;
    }

    public void wrenchUsed(EntityPlayer player, Entity entity) {
    }

    @Override
    public boolean canUseWrench(ItemStack stack, EntityPlayer player, BlockPos pos) {
        return this.getState(stack) == ConfiguratorMode.WRENCH;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.getState(stack) == ConfiguratorMode.WRENCH;
    }

    @Override
    public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        return user instanceof EntityPlayer && this.canUseWrench(item, (EntityPlayer)user, pos);
    }

    @Override
    public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        return user instanceof EntityPlayer && this.canUseWrench(item, (EntityPlayer)user, null);
    }

    @Override
    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
    }

    @Override
    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
    }

    public static enum ConfiguratorMode {
        CONFIGURATE_ITEMS("configurate", "(" + TransmissionType.ITEM.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_FLUIDS("configurate", "(" + TransmissionType.FLUID.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_GASES("configurate", "(" + TransmissionType.GAS.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_ENERGY("configurate", "(" + TransmissionType.ENERGY.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_HEAT("configurate", "(" + TransmissionType.HEAT.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        EMPTY("empty", "", EnumColor.DARK_RED, false),
        ROTATE("rotate", "", EnumColor.YELLOW, false),
        WRENCH("wrench", "", EnumColor.PINK, false);

        private String name;
        private String info;
        private EnumColor color;
        private boolean configurating;

        private ConfiguratorMode(String s, String s1, EnumColor c, boolean b) {
            this.name = s;
            this.info = s1;
            this.color = c;
            this.configurating = b;
        }

        public String getName() {
            return LangUtils.localize("tooltip.configurator." + this.name) + " " + this.info;
        }

        public EnumColor getColor() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        public TransmissionType getTransmission() {
            switch (this) {
                case CONFIGURATE_ITEMS: {
                    return TransmissionType.ITEM;
                }
                case CONFIGURATE_FLUIDS: {
                    return TransmissionType.FLUID;
                }
                case CONFIGURATE_GASES: {
                    return TransmissionType.GAS;
                }
                case CONFIGURATE_ENERGY: {
                    return TransmissionType.ENERGY;
                }
                case CONFIGURATE_HEAT: {
                    return TransmissionType.HEAT;
                }
            }
            return null;
        }
    }
}

