/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import mekanism.api.util.StackUtils;
import mekanism.common.Tier;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryBin {
    public ItemStack bin;

    public InventoryBin(ItemStack stack) {
        this.bin = stack;
    }

    public ItemStack getStack() {
        if (this.getItemCount() > 0 && this.getItemType() != null) {
            ItemStack ret = this.getItemType().func_77946_l();
            ret.field_77994_a = Math.min(this.getItemType().func_77976_d(), this.getItemCount());
            return ret;
        }
        return null;
    }

    public ItemStack removeStack() {
        ItemStack stack = this.getStack();
        if (stack == null) {
            return null;
        }
        this.setItemCount(this.getItemCount() - stack.field_77994_a);
        return stack.func_77946_l();
    }

    public ItemStack add(ItemStack stack) {
        if (this.isValid(stack) && this.getItemCount() != this.getMaxStorage()) {
            if (this.getItemType() == null) {
                this.setItemType(stack);
            }
            if (this.getItemCount() + stack.field_77994_a <= this.getMaxStorage()) {
                this.setItemCount(this.getItemCount() + stack.field_77994_a);
                return null;
            }
            ItemStack rejects = this.getItemType().func_77946_l();
            rejects.field_77994_a = this.getItemCount() + stack.field_77994_a - this.getMaxStorage();
            this.setItemCount(this.getMaxStorage());
            return rejects;
        }
        return stack;
    }

    public boolean isValid(ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return false;
        }
        if (BlockStateBasic.BasicBlockType.get(stack) == BlockStateBasic.BasicBlockType.BIN) {
            return false;
        }
        if (this.getItemType() == null) {
            return true;
        }
        return stack.func_77969_a(this.getItemType()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.getItemType());
    }

    public int getMaxStorage() {
        return Tier.BinTier.values()[((ITierItem)this.bin.func_77973_b()).getBaseTier((ItemStack)this.bin).ordinal()].storage;
    }

    public int getItemCount() {
        return ItemDataUtils.getInt(this.bin, "itemCount");
    }

    public void setItemCount(int count) {
        ItemDataUtils.setInt(this.bin, "itemCount", Math.max(0, count));
        if (this.getItemCount() == 0) {
            this.setItemType(null);
        }
    }

    public ItemStack getItemType() {
        if (this.getItemCount() == 0) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)ItemDataUtils.getCompound(this.bin, "storedItem"));
    }

    public void setItemType(ItemStack stack) {
        if (stack == null) {
            ItemDataUtils.removeData(this.bin, "storedItem");
            return;
        }
        ItemDataUtils.setCompound(this.bin, "storedItem", StackUtils.size(stack, 1).func_77955_b(new NBTTagCompound()));
    }
}

