/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import mekanism.api.Coord4D;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class DynamicFluidTank
implements IFluidTank {
    public TileEntityDynamicTank dynamicTank;

    public DynamicFluidTank(TileEntityDynamicTank tileEntity) {
        this.dynamicTank = tileEntity;
    }

    public FluidStack getFluid() {
        return this.dynamicTank.structure != null ? ((SynchronizedTankData)this.dynamicTank.structure).fluidStored : null;
    }

    public int getCapacity() {
        return this.dynamicTank.structure != null ? ((SynchronizedTankData)this.dynamicTank.structure).volume * 16000 : 0;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.dynamicTank.structure != null && !this.dynamicTank.func_145831_w().field_72995_K) {
            if (resource == null || resource.getFluid() == null) {
                return 0;
            }
            if (((SynchronizedTankData)this.dynamicTank.structure).fluidStored != null && !((SynchronizedTankData)this.dynamicTank.structure).fluidStored.isFluidEqual(resource)) {
                return 0;
            }
            if (((SynchronizedTankData)this.dynamicTank.structure).fluidStored == null || ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.getFluid() == null) {
                if (resource.amount <= this.getCapacity()) {
                    if (doFill) {
                        ((SynchronizedTankData)this.dynamicTank.structure).fluidStored = resource.copy();
                        if (resource.amount > 0) {
                            MekanismUtils.saveChunk(this.dynamicTank);
                            this.updateValveData();
                        }
                    }
                    return resource.amount;
                }
                if (doFill) {
                    ((SynchronizedTankData)this.dynamicTank.structure).fluidStored = resource.copy();
                    ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount = this.getCapacity();
                    if (this.getCapacity() > 0) {
                        MekanismUtils.saveChunk(this.dynamicTank);
                        this.updateValveData();
                    }
                }
                return this.getCapacity();
            }
            if (resource.amount <= this.getNeeded()) {
                if (doFill) {
                    ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount += resource.amount;
                    if (resource.amount > 0) {
                        MekanismUtils.saveChunk(this.dynamicTank);
                        this.updateValveData();
                    }
                }
                return resource.amount;
            }
            int prevNeeded = this.getNeeded();
            if (doFill) {
                ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount = this.getCapacity();
                if (prevNeeded > 0) {
                    MekanismUtils.saveChunk(this.dynamicTank);
                    this.updateValveData();
                }
            }
            return prevNeeded;
        }
        return 0;
    }

    public void updateValveData() {
        if (this.dynamicTank.structure != null) {
            for (SynchronizedTankData.ValveData data : ((SynchronizedTankData)this.dynamicTank.structure).valves) {
                if (!data.location.equals(Coord4D.get(this.dynamicTank))) continue;
                data.onTransfer();
            }
        }
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.dynamicTank.structure != null && !this.dynamicTank.func_145831_w().field_72995_K) {
            if (((SynchronizedTankData)this.dynamicTank.structure).fluidStored == null || ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.getFluid() == null) {
                return null;
            }
            if (((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount <= 0) {
                return null;
            }
            int used = maxDrain;
            if (((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount < used) {
                used = ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount;
            }
            if (doDrain) {
                ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount -= used;
            }
            FluidStack drained = new FluidStack(((SynchronizedTankData)this.dynamicTank.structure).fluidStored.getFluid(), used);
            if (((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount <= 0) {
                ((SynchronizedTankData)this.dynamicTank.structure).fluidStored = null;
            }
            if (drained.amount > 0 && doDrain) {
                MekanismUtils.saveChunk(this.dynamicTank);
                this.dynamicTank.sendPacketToRenderer();
            }
            return drained;
        }
        return null;
    }

    public int getNeeded() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public int getFluidAmount() {
        if (this.dynamicTank.structure != null) {
            return ((SynchronizedTankData)this.dynamicTank.structure).fluidStored.amount;
        }
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

