/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import buildcraft.api.tools.IToolWrench;
import java.util.List;
import java.util.Random;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateEnergyCube;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnergyCube
extends BlockContainer {
    public BlockEnergyCube() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(4.0f);
        this.func_149647_a(Mekanism.tabMekanism);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateEnergyCube(this);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityEnergyCube) {
            TileEntityEnergyCube cube = (TileEntityEnergyCube)tile;
            if (cube.facing != null) {
                state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)cube.facing);
            }
            if (cube.tier != null) {
                state = state.func_177226_a(BlockStateEnergyCube.typeProperty, (Comparable)((Object)cube.tier));
            }
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        int side = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(placer.field_70125_A);
        int change = 3;
        if (height >= 65) {
            change = 1;
        } else if (height <= -65) {
            change = 0;
        } else {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        tileEntity.setFacing((short)change);
        tileEntity.redstone = world.func_175687_A(pos) > 0;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, List<ItemStack> list) {
        for (Tier.EnergyCubeTier tier : Tier.EnergyCubeTier.values()) {
            ItemStack discharged = new ItemStack((Block)this);
            ((ItemBlockEnergyCube)discharged.func_77973_b()).setBaseTier(discharged, tier.getBaseTier());
            list.add(discharged);
            ItemStack charged = new ItemStack((Block)this);
            ((ItemBlockEnergyCube)charged.func_77973_b()).setBaseTier(charged, tier.getBaseTier());
            ((ItemBlockEnergyCube)charged.func_77973_b()).setEnergy(charged, tier.maxEnergy);
            list.add(charged);
        }
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return SecurityUtils.canAccess(player, tile) ? super.func_180647_a(state, player, world, pos) : 0.0f;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_175625_s(pos);
        if (stack != null) {
            Item tool = stack.func_77973_b();
            if (MekanismUtils.hasUsableWrench(entityplayer, pos)) {
                if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                    if (entityplayer.func_70093_af()) {
                        this.dismantleBlock(state, world, pos, false);
                        return true;
                    }
                    if (MekanismUtils.isBCWrench(tool)) {
                        ((IToolWrench)tool).wrenchUsed(entityplayer, pos);
                    }
                    int change = tileEntity.facing.func_176732_a(side.func_176740_k()).ordinal();
                    tileEntity.setFacing((short)change);
                    world.func_175685_c(pos, (Block)this);
                } else {
                    SecurityUtils.displayNoAccess(entityplayer);
                }
                return true;
            }
        }
        if (tileEntity != null && !entityplayer.func_70093_af()) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                entityplayer.openGui((Object)Mekanism.instance, 8, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, this.getPickBlock(state, null, world, pos, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_175698_g(pos);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityEnergyCube();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ISecurityItem securityItem;
        TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_175625_s(pos);
        ItemStack itemStack = new ItemStack(MekanismBlocks.EnergyCube);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity instanceof ISecurityTile && (securityItem = (ISecurityItem)itemStack.func_77973_b()).hasSecurity(itemStack)) {
            securityItem.setOwner(itemStack, tileEntity.getSecurity().getOwner());
            securityItem.setSecurity(itemStack, tileEntity.getSecurity().getMode());
        }
        ITierItem tierItem = (ITierItem)itemStack.func_77973_b();
        tierItem.setBaseTier(itemStack, tileEntity.tier.getBaseTier());
        IEnergizedItem energizedItem = (IEnergizedItem)itemStack.func_77973_b();
        energizedItem.setEnergy(itemStack, tileEntity.electricityStored);
        ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
        inventory.setInventory(tileEntity.getInventory(new Object[0]), itemStack);
        return itemStack;
    }

    public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(state, null, world, pos, null);
        world.func_175698_g(pos);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_175625_s(pos);
        return tileEntity.getRedstoneLevel();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }
}

