/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Matrix4f;
import mekanism.api.MekanismConfig;
import mekanism.client.render.ctm.CTMModelFactory;
import mekanism.client.render.obj.OBJBakedModelBase;
import mekanism.common.multipart.ColorProperty;
import mekanism.common.multipart.ConnectionProperty;
import mekanism.common.multipart.PartSidedPipe;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class TransmitterModel
extends OBJBakedModelBase {
    private static Set<TransmitterModel> modelInstances = new HashSet<TransmitterModel>();
    private Map<Integer, List<BakedQuad>> modelCache = new HashMap<Integer, List<BakedQuad>>();
    private TransmitterModel itemCache;
    private IBlockState tempState;
    private ItemStack tempStack;
    private static TextureAtlasSprite[] transporter_center = new TextureAtlasSprite[2];
    private static TextureAtlasSprite[] transporter_center_color = new TextureAtlasSprite[2];
    private static TextureAtlasSprite[] transporter_side = new TextureAtlasSprite[2];
    private static TextureAtlasSprite[] transporter_side_color = new TextureAtlasSprite[2];
    private TransmitterOverride override = new TransmitterOverride();

    public TransmitterModel(IBakedModel base, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, HashMap<ItemCameraTransforms.TransformType, Matrix4f> transform) {
        super(base, model, state, format, textures, transform);
        modelInstances.add(this);
    }

    public ItemOverrideList func_188617_f() {
        return this.override;
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (state != null && this.tempState == null) {
            IExtendedBlockState extended = (IExtendedBlockState)state;
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            ColorProperty colorProp = (ColorProperty)extended.getValue((IUnlistedProperty)ColorProperty.INSTANCE);
            int color = -1;
            if (colorProp != null && colorProp.color != null) {
                color = ((ColorProperty)extended.getValue((IUnlistedProperty)ColorProperty.INSTANCE)).color.ordinal();
            }
            OBJModel.OBJState obj = (OBJModel.OBJState)extended.getValue((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE);
            if (layer != BlockRenderLayer.TRANSLUCENT) {
                color = -1;
            }
            int hash = Objects.hash(layer.ordinal(), color, obj.hashCode());
            if (obj.getVisibilityMap().containsKey("OBJModel.Group.All.Key") || obj.getVisibilityMap().containsKey("OBJModel.Group.All.Except.Key")) {
                this.updateStateVisibilityMap(obj);
            }
            if (!this.modelCache.containsKey(hash)) {
                TransmitterModel model = new TransmitterModel(this.baseModel, this.getModel(), (IModelState)obj, this.vertexFormat, (ImmutableMap<String, TextureAtlasSprite>)this.textureMap, this.transformationMap);
                model.tempState = state;
                this.modelCache.put(hash, model.func_188616_a(state, side, rand));
            }
            return this.modelCache.get(hash);
        }
        return super.func_188616_a(state, side, rand);
    }

    @Override
    public float[] getOverrideColor(OBJModel.Face f, String groupName) {
        if (this.tempState != null) {
            ColorProperty prop = (ColorProperty)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)ColorProperty.INSTANCE);
            if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT && prop != null && prop.color != null) {
                return new float[]{prop.color.getColor(0), prop.color.getColor(1), prop.color.getColor(2), 1.0f};
            }
        }
        return null;
    }

    @Override
    public TextureAtlasSprite getOverrideTexture(OBJModel.Face f, String groupName) {
        if (this.tempState != null) {
            boolean sideIconOverride;
            EnumFacing side = EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z);
            ColorProperty prop = (ColorProperty)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)ColorProperty.INSTANCE);
            ConnectionProperty connection = (ConnectionProperty)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)ConnectionProperty.INSTANCE);
            boolean bl = sideIconOverride = this.getIconStatus(side, connection) > 0;
            if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT) {
                int opaqueVal;
                int n = opaqueVal = MekanismConfig.client.opaqueTransmitters ? 1 : 0;
                if (prop != null && prop.color != null) {
                    return !sideIconOverride && f.getMaterialName().contains("Center") ? transporter_center_color[opaqueVal] : transporter_side_color[opaqueVal];
                }
                return !sideIconOverride && f.getMaterialName().contains("Center") ? transporter_center[opaqueVal] : transporter_side[opaqueVal];
            }
            if (groupName.endsWith("NONE") && sideIconOverride) {
                for (String s : this.getModel().getMatLib().getMaterialNames()) {
                    if (s.contains("Texture.Name") || s.contains("Center") || s.contains("Centre") || !(MekanismConfig.client.opaqueTransmitters ? s.contains("Opaque") : !s.contains("Opaque"))) continue;
                    return (TextureAtlasSprite)this.textureMap.get((Object)s);
                }
            } else if (MekanismConfig.client.opaqueTransmitters) {
                return (TextureAtlasSprite)this.textureMap.get((Object)(f.getMaterialName() + "_Opaque"));
            }
        }
        return null;
    }

    @Override
    public boolean shouldRotate(OBJModel.Face f, String groupName) {
        if (this.tempState != null) {
            EnumFacing side = EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z);
            ConnectionProperty connection = (ConnectionProperty)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)ConnectionProperty.INSTANCE);
            if (groupName.endsWith("NONE") && this.getIconStatus(side, connection) == 2) {
                return true;
            }
        }
        return false;
    }

    public byte getIconStatus(EnumFacing side, ConnectionProperty connection) {
        PartSidedPipe.ConnectionType type = PartSidedPipe.getConnectionType(side, connection.connectionByte, connection.transmitterConnections, connection.connectionTypes);
        if (type == PartSidedPipe.ConnectionType.NONE) {
            if (MekanismConfig.client.oldTransmitterRender || connection.renderCenter) {
                return 0;
            }
            if (connection.connectionByte == 3 && side != EnumFacing.DOWN && side != EnumFacing.UP) {
                return 1;
            }
            if (connection.connectionByte == 12 && (side == EnumFacing.DOWN || side == EnumFacing.UP)) {
                return 1;
            }
            if (connection.connectionByte == 12 && (side == EnumFacing.EAST || side == EnumFacing.WEST)) {
                return 2;
            }
            if (connection.connectionByte == 48 && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return 2;
            }
        }
        return 0;
    }

    public Pair<? extends IPerspectiveAwareModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)((Object)this), (Object)CTMModelFactory.transforms.get(cameraTransformType).getMatrix());
    }

    public static void registerIcons(TextureMap map) {
        TransmitterModel.transporter_center[0] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/LogisticalTransporterGlass"));
        TransmitterModel.transporter_center_color[0] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/LogisticalTransporterGlassColored"));
        TransmitterModel.transporter_side[0] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/LogisticalTransporterVerticalGlass"));
        TransmitterModel.transporter_side_color[0] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/LogisticalTransporterVerticalGlassColored"));
        TransmitterModel.transporter_center[1] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/opaque/LogisticalTransporterGlass"));
        TransmitterModel.transporter_center_color[1] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/opaque/LogisticalTransporterGlassColored"));
        TransmitterModel.transporter_side[1] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/opaque/LogisticalTransporterVerticalGlass"));
        TransmitterModel.transporter_side_color[1] = map.func_174942_a(new ResourceLocation("mekanism:blocks/models/multipart/opaque/LogisticalTransporterVerticalGlassColored"));
    }

    public static void clearCache() {
        for (TransmitterModel model : modelInstances) {
            model.modelCache.clear();
            model.itemCache = null;
        }
    }

    private class TransmitterOverride
    extends ItemOverrideList {
        public TransmitterOverride() {
            super((List)Lists.newArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (TransmitterModel.this.itemCache == null) {
                ArrayList<String> visible = new ArrayList<String>();
                for (EnumFacing side : EnumFacing.values()) {
                    visible.add(side.func_176610_l() + (side.func_176740_k() == EnumFacing.Axis.Y ? "NORMAL" : "NONE"));
                }
                TransmitterModel.this.itemCache = new TransmitterModel(TransmitterModel.this.baseModel, TransmitterModel.this.getModel(), (IModelState)new OBJModel.OBJState(visible, true), TransmitterModel.this.vertexFormat, (ImmutableMap<String, TextureAtlasSprite>)TransmitterModel.this.textureMap, TransmitterModel.this.transformationMap);
                TransmitterModel.this.itemCache.tempStack = stack;
            }
            return TransmitterModel.this.itemCache;
        }
    }
}

