/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import mekanism.client.render.obj.GlowPanelModel;
import mekanism.client.render.obj.TransmitterModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;

public class MekanismOBJModel
extends OBJModel {
    public OBJModelType modelType;
    public ResourceLocation location;

    public MekanismOBJModel(OBJModelType type, OBJModel.MaterialLibrary matLib, ResourceLocation modelLocation) {
        super(matLib, modelLocation);
        this.modelType = type;
        this.location = modelLocation;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel preBaked = super.bake(state, format, bakedTextureGetter);
        if (this.modelType == OBJModelType.GLOW_PANEL) {
            return new GlowPanelModel(preBaked, this, state, format, GlowPanelModel.getTexturesForOBJModel(preBaked), null);
        }
        if (this.modelType == OBJModelType.TRANSMITTER) {
            return new TransmitterModel(preBaked, this, state, format, TransmitterModel.getTexturesForOBJModel(preBaked), null);
        }
        return null;
    }

    public IModel process(ImmutableMap<String, String> customData) {
        MekanismOBJModel ret = new MekanismOBJModel(this.modelType, this.getMatLib(), this.location);
        return ret;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        MekanismOBJModel ret = new MekanismOBJModel(this.modelType, this.getMatLib().makeLibWithReplacements(textures), this.location);
        return ret;
    }

    public static enum OBJModelType {
        GLOW_PANEL,
        TRANSMITTER;

    }
}

