/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.ctm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mekanism.client.render.ctm.CTM;
import mekanism.client.render.ctm.CTMBlockRenderContext;
import mekanism.client.render.ctm.Quad;
import mekanism.client.render.ctm.TextureSpriteCallback;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;

public class TextureCTM {
    protected BlockRenderLayer layer;
    public TextureSpriteCallback[] sprites;

    public TextureCTM(BlockRenderLayer layer, TextureSpriteCallback[] sprites) {
        this.layer = layer;
        this.sprites = sprites;
    }

    public List<BakedQuad> transformQuad(BakedQuad bq, CTMBlockRenderContext context, int quadGoal) {
        Quad quad = Quad.from(bq, DefaultVertexFormats.field_176599_b);
        if (context == null) {
            return Collections.singletonList(quad.transformUVs(this.sprites[0].getSprite()).rebake());
        }
        Quad[] quads = quad.subdivide(4);
        int[] ctm = context.getCTM(bq.func_178210_d()).getSubmapIndices();
        for (int i = 0; i < quads.length; ++i) {
            Quad q2 = quads[i];
            if (q2 == null) continue;
            int ctmid = q2.getUVs().normalize().getQuadrant();
            quads[i] = q2.grow().transformUVs(this.sprites[ctm[ctmid] > 15 ? 0 : 1].getSprite(), CTM.uvs[ctm[ctmid]].normalize());
        }
        return Arrays.stream(quads).filter(Objects::nonNull).map(q -> q.rebake()).collect(Collectors.toList());
    }

    public TextureAtlasSprite getParticle() {
        return this.sprites[0].getSprite();
    }

    public Collection<ResourceLocation> getTextures() {
        return Arrays.stream(this.sprites).map(TextureSpriteCallback::getLocation).collect(Collectors.toList());
    }
}

