/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.util;

import com.zerofall.ezstorage.util.EZStorageUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ItemGroup {
    public ItemStack itemStack;
    public long count;
    public boolean highlighted;

    public ItemGroup(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.count = itemStack.field_77994_a;
    }

    public ItemGroup(ItemStack itemStack, long count) {
        this.itemStack = itemStack;
        this.count = count;
    }

    public String toString() {
        return this.itemStack.func_82833_r() + ":" + this.count;
    }

    public static class InverseModNameComparator
    extends ItemGroupComparator {
        @Override
        public int compare(ItemGroup group1, ItemGroup group2) {
            String n2;
            String m1 = group1.itemStack.func_77973_b().getRegistryName().func_110624_b();
            String m2 = group2.itemStack.func_77973_b().getRegistryName().func_110624_b();
            String n1 = EZStorageUtils.getModNameFromID(m1).toLowerCase();
            if (!n1.equals(n2 = EZStorageUtils.getModNameFromID(m2).toLowerCase())) {
                return n2.compareTo(n1);
            }
            Long l1 = group1.count;
            Long l2 = group2.count;
            return l1.compareTo(l2);
        }
    }

    public static class ModNameComparator
    extends ItemGroupComparator {
        @Override
        public int compare(ItemGroup group1, ItemGroup group2) {
            String n2;
            String m1 = group1.itemStack.func_77973_b().getRegistryName().func_110624_b();
            String m2 = group2.itemStack.func_77973_b().getRegistryName().func_110624_b();
            String n1 = EZStorageUtils.getModNameFromID(m1).toLowerCase();
            if (!n1.equals(n2 = EZStorageUtils.getModNameFromID(m2).toLowerCase())) {
                return n1.compareTo(n2);
            }
            Long l1 = group1.count;
            Long l2 = group2.count;
            return l2.compareTo(l1);
        }
    }

    public static class InverseNameComparator
    extends ItemGroupComparator {
        @Override
        public int compare(ItemGroup group1, ItemGroup group2) {
            String n2;
            String n1 = group1.itemStack.func_82833_r();
            if (!n1.equals(n2 = group2.itemStack.func_82833_r())) {
                return n2.compareTo(n1);
            }
            Long l1 = group1.count;
            Long l2 = group2.count;
            return l1.compareTo(l2);
        }
    }

    public static class NameComparator
    extends ItemGroupComparator {
        @Override
        public int compare(ItemGroup group1, ItemGroup group2) {
            String n2;
            String n1 = group1.itemStack.func_82833_r();
            if (!n1.equals(n2 = group2.itemStack.func_82833_r())) {
                return n1.compareTo(n2);
            }
            Long l1 = group1.count;
            Long l2 = group2.count;
            return l2.compareTo(l1);
        }
    }

    public static class InverseCountComparator
    extends ItemGroupComparator {
        @Override
        public int compare(ItemGroup group1, ItemGroup group2) {
            Long l2;
            Long l1 = group1.count;
            if (l1 != (l2 = Long.valueOf(group2.count))) {
                return l1.compareTo(l2);
            }
            String n1 = group1.itemStack.func_82833_r();
            String n2 = group2.itemStack.func_82833_r();
            return n2.compareTo(n1);
        }
    }

    public static class CountComparator
    extends ItemGroupComparator {
        @Override
        public int compare(ItemGroup group1, ItemGroup group2) {
            Long l2;
            Long l1 = group1.count;
            if (l1 != (l2 = Long.valueOf(group2.count))) {
                return l2.compareTo(l1);
            }
            String n1 = group1.itemStack.func_82833_r();
            String n2 = group2.itemStack.func_82833_r();
            return n1.compareTo(n2);
        }
    }

    public static abstract class ItemGroupComparator
    implements Comparator<ItemGroup> {
    }

    public static enum EnumSortMode {
        COUNT(CountComparator.class, "Count Down", "Sorts by descending item counts, then from A-Z for equal cases."),
        INVERSE_COUNT(InverseCountComparator.class, "Count Up", "Sorts by ascending item counts, then from Z-A for equal cases."),
        NAME(NameComparator.class, "Name A - Z", "Sorts A-Z, then by descending item counts for equal cases."),
        INVERSE_NAME(InverseNameComparator.class, "Name Z - A", "Sorts Z-A, then by ascending item counts for equal cases."),
        MOD_NAME(ModNameComparator.class, "Mod A - Z", "Sorts by mod name A-Z, then by descending item counts for equal cases."),
        INVERSE_MOD_NAME(InverseModNameComparator.class, "Mod Z - A", "Sorts by mod name Z-A, then by ascending item counts for equal cases.");

        private Class<? extends ItemGroupComparator> sortClass;
        private String name;
        private String desc;

        private EnumSortMode(Class<? extends ItemGroupComparator> sortClass, String name, String desc) {
            this.sortClass = sortClass;
            this.name = name;
            this.desc = desc;
        }

        public static EnumSortMode fromInt(int mode) {
            return EnumSortMode.values()[mode % EnumSortMode.values().length];
        }

        public EnumSortMode rotateMode() {
            return EnumSortMode.fromInt(this.ordinal() + 1);
        }

        public void sortInventory(List<ItemGroup> inventory) {
            try {
                Collections.sort(inventory, this.sortClass.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

