/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.util;

import com.zerofall.ezstorage.block.BlockSecurityBox;
import com.zerofall.ezstorage.block.StorageMultiblock;
import com.zerofall.ezstorage.tileentity.TileEntitySecurityBox;
import com.zerofall.ezstorage.util.BlockRef;
import com.zerofall.ezstorage.util.JointList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class EZStorageUtils {
    private static HashMap<String, String> modMap = new HashMap();

    public static String getModNameFromID(String modid) {
        if (modMap.isEmpty()) {
            for (ModContainer m : Loader.instance().getModList()) {
                modMap.put(m.getModId(), m.getName());
            }
        }
        if (modMap.containsKey(modid)) {
            return modMap.get(modid);
        }
        return "";
    }

    public static List<BlockRef> getNeighbors(int xCoord, int yCoord, int zCoord, World world) {
        ArrayList<BlockRef> blockList = new ArrayList<BlockRef>();
        blockList.add(new BlockRef(world.func_180495_p(new BlockPos(xCoord - 1, yCoord, zCoord)).func_177230_c(), xCoord - 1, yCoord, zCoord));
        blockList.add(new BlockRef(world.func_180495_p(new BlockPos(xCoord + 1, yCoord, zCoord)).func_177230_c(), xCoord + 1, yCoord, zCoord));
        blockList.add(new BlockRef(world.func_180495_p(new BlockPos(xCoord, yCoord - 1, zCoord)).func_177230_c(), xCoord, yCoord - 1, zCoord));
        blockList.add(new BlockRef(world.func_180495_p(new BlockPos(xCoord, yCoord + 1, zCoord)).func_177230_c(), xCoord, yCoord + 1, zCoord));
        blockList.add(new BlockRef(world.func_180495_p(new BlockPos(xCoord, yCoord, zCoord - 1)).func_177230_c(), xCoord, yCoord, zCoord - 1));
        blockList.add(new BlockRef(world.func_180495_p(new BlockPos(xCoord - 1, yCoord, zCoord)).func_177230_c(), xCoord - 1, yCoord, zCoord));
        blockList.add(new BlockRef(world.func_180495_p(new BlockPos(xCoord, yCoord, zCoord + 1)).func_177230_c(), xCoord, yCoord, zCoord + 1));
        return blockList;
    }

    public static void notifyBlockUpdate(TileEntity entity) {
        EZStorageUtils.notifyBlockUpdate(entity.func_145831_w(), entity.func_174877_v());
    }

    public static void notifyBlockUpdate(World world, BlockPos pos) {
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }

    public static TileEntitySecurityBox findSecurityBox(BlockRef br, World world, Set<BlockRef> scanned) {
        if (scanned == null) {
            scanned = new HashSet<BlockRef>();
        }
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.pos.func_177958_n(), br.pos.func_177956_o(), br.pos.func_177952_p(), world);
        for (BlockRef blockRef : neighbors) {
            TileEntitySecurityBox entity;
            if (!(blockRef.block instanceof StorageMultiblock)) continue;
            if (blockRef.block instanceof BlockSecurityBox) {
                return (TileEntitySecurityBox)world.func_175625_s(blockRef.pos);
            }
            if (!scanned.add(blockRef) || (entity = EZStorageUtils.findSecurityBox(blockRef, world, scanned)) == null) continue;
            return entity;
        }
        return null;
    }

    public static List<EntityPlayer> getNearbyPlayers(World world, BlockPos pos, double distance, int maxCount) {
        int count = 0;
        JointList<EntityPlayer> list = new JointList<EntityPlayer>();
        for (EntityPlayer p : world.field_73010_i) {
            if (count >= maxCount || !(p.func_174818_b(pos) < distance * distance)) continue;
            list.add(p);
            ++count;
        }
        return list;
    }
}

