/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.util;

import com.zerofall.ezstorage.gui.server.InventoryExtractList;
import com.zerofall.ezstorage.tileentity.TileEntityExtractPort;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.ItemGroup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class EZInventory {
    public TileEntityStorageCore tile;
    public List<ItemGroup> inventory = new ArrayList<ItemGroup>();
    public long maxItems = 0L;

    public EZInventory(TileEntityStorageCore tile) {
        this.tile = tile;
    }

    public ItemStack input(ItemStack itemStack) {
        return this.input(itemStack, true);
    }

    public ItemStack input(ItemStack itemStack, boolean sort) {
        if (this.getTotalCount() >= this.maxItems) {
            return itemStack;
        }
        long space = this.maxItems - this.getTotalCount();
        int amount = (int)Math.min(space, (long)itemStack.field_77994_a);
        ItemStack result = this.mergeStack(itemStack, amount);
        if (sort) {
            this.tile.sortInventory();
        } else {
            this.tile.updateInventory();
        }
        return result;
    }

    public void sort() {
        this.tile.sortMode.sortInventory(this.inventory);
    }

    private ItemStack mergeStack(ItemStack itemStack, int amount) {
        for (ItemGroup group : this.inventory) {
            if (!EZInventory.stacksEqual(group.itemStack, itemStack)) continue;
            group.count += (long)amount;
            itemStack.field_77994_a -= amount;
            if (itemStack.field_77994_a <= 0) {
                return null;
            }
            return itemStack;
        }
        this.inventory.add(new ItemGroup(itemStack, amount));
        itemStack.field_77994_a -= amount;
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public ItemStack getItemsAt(int index, int type) {
        return this.getItemsAt(index, type, -1);
    }

    public ItemStack getItemsAt(int index, int type, int size) {
        return this.getItemsAt(index, type, size, false);
    }

    public ItemStack getItemsAt(int index, int type, int size, boolean peek) {
        if (index >= this.inventory.size()) {
            return null;
        }
        ItemGroup group = this.inventory.get(index);
        ItemStack stack = group.itemStack.func_77946_l();
        if (size > 1) {
            if (type == 1) {
                size /= 2;
            } else if (type == 2) {
                size = 1;
            }
        }
        return this.extractStack(group, size, peek);
    }

    public ItemStack getItemsExtractList(TileEntityExtractPort.EnumListMode mode, InventoryExtractList list, int size, boolean peek) {
        if (list.isEmpty()) {
            return this.getItemsAt(0, 0, size, peek);
        }
        for (int i = 0; i < list.func_70302_i_(); ++i) {
            ItemStack comp = list.func_70301_a(i);
            if (comp == null) continue;
            for (ItemGroup g : this.inventory) {
                if (EZInventory.stacksEqualOreDict(comp, g.itemStack)) {
                    if (mode == TileEntityExtractPort.EnumListMode.BLACKLIST) continue;
                    return this.extractStack(g, size, peek);
                }
                if (mode == TileEntityExtractPort.EnumListMode.WHITELIST) continue;
                return this.extractStack(g, size, peek);
            }
        }
        return null;
    }

    public ItemStack getItemsExtractList(TileEntityExtractPort.EnumListMode mode, InventoryExtractList list, int size) {
        return this.getItemsExtractList(mode, list, size, false);
    }

    public ItemStack peekItemsExtractList(TileEntityExtractPort.EnumListMode mode, InventoryExtractList list) {
        return this.getItemsExtractList(mode, list, -1, true);
    }

    private ItemStack extractStack(ItemGroup group, int stackSize, boolean peek) {
        ItemStack stack = group.itemStack.func_77946_l();
        stackSize = stackSize < 0 ? (int)Math.min((long)stack.func_77976_d(), group.count) : Math.min(stack.func_77976_d(), (int)Math.min((long)stackSize, group.count));
        stack.field_77994_a = stackSize;
        if (!peek) {
            group.count -= (long)stackSize;
            if (group.count <= 0L) {
                this.inventory.remove(group);
                this.tile.sortInventory();
            } else {
                this.tile.updateInventory();
            }
        }
        return stack;
    }

    public ItemStack getItems(ItemStack[] itemStacks) {
        for (ItemGroup group : this.inventory) {
            for (ItemStack itemStack : itemStacks) {
                if (!EZInventory.stacksEqualOreDict(group.itemStack, itemStack)) continue;
                if (group.count >= (long)itemStack.field_77994_a) {
                    ItemStack stack = group.itemStack.func_77946_l();
                    stack.field_77994_a = itemStack.field_77994_a;
                    group.count -= (long)itemStack.field_77994_a;
                    if (group.count <= 0L) {
                        this.inventory.remove(group);
                    }
                    return stack;
                }
                return null;
            }
        }
        return null;
    }

    public int slotCount() {
        return this.inventory.size();
    }

    public static boolean stacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && (!stack1.func_77942_o() && !stack2.func_77942_o() || stack1.func_77942_o() && stack1.func_77978_p().equals((Object)stack2.func_77978_p()));
    }

    public static boolean stacksEqualOreDict(ItemStack stack1, ItemStack stack2) {
        boolean first = EZInventory.stacksEqual(stack1, stack2);
        boolean nullCheck = stack1 != null && stack2 != null;
        boolean second = stack1.func_77973_b() == stack2.func_77973_b();
        boolean third = stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE;
        return first || nullCheck && second && third;
    }

    public long getTotalCount() {
        long count = 0L;
        for (ItemGroup group : this.inventory) {
            count += group.count;
        }
        return count;
    }

    public int indexOf(ItemGroup group) {
        int n = 0;
        for (ItemGroup g : this.inventory) {
            if (EZInventory.stacksEqual(g.itemStack, group.itemStack)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String toString() {
        return this.inventory.toString();
    }
}

