/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.tileentity;

import com.zerofall.ezstorage.EZStorage;
import com.zerofall.ezstorage.block.BlockCraftingBox;
import com.zerofall.ezstorage.block.BlockExtractPort;
import com.zerofall.ezstorage.block.BlockInputPort;
import com.zerofall.ezstorage.block.BlockOutputPort;
import com.zerofall.ezstorage.block.BlockSearchBox;
import com.zerofall.ezstorage.block.BlockSortBox;
import com.zerofall.ezstorage.block.BlockStorage;
import com.zerofall.ezstorage.block.BlockStorageCore;
import com.zerofall.ezstorage.block.StorageMultiblock;
import com.zerofall.ezstorage.gui.server.InventoryExtractList;
import com.zerofall.ezstorage.init.EZBlocks;
import com.zerofall.ezstorage.network.MessageFilterUpdate;
import com.zerofall.ezstorage.tileentity.TileEntityBase;
import com.zerofall.ezstorage.tileentity.TileEntityEjectPort;
import com.zerofall.ezstorage.tileentity.TileEntityExtractPort;
import com.zerofall.ezstorage.tileentity.TileEntityInputPort;
import com.zerofall.ezstorage.util.BlockRef;
import com.zerofall.ezstorage.util.EZInventory;
import com.zerofall.ezstorage.util.EZStorageUtils;
import com.zerofall.ezstorage.util.ItemGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityStorageCore
extends TileEntityBase {
    public EZInventory inventory;
    Set<BlockRef> multiblock = new HashSet<BlockRef>();
    public boolean disabled = false;
    private boolean firstTick = false;
    public boolean hasCraftBox = false;
    public boolean hasSearchBox = false;
    public ItemGroup.EnumSortMode sortMode = ItemGroup.EnumSortMode.COUNT;
    public boolean hasSortBox = false;

    public TileEntityStorageCore() {
        this.inventory = new EZInventory(this);
    }

    public ItemStack input(ItemStack stack) {
        ItemStack result = this.inventory.input(stack, false);
        return result;
    }

    public ItemStack getFirstStack(int size, TileEntityExtractPort.EnumListMode mode, InventoryExtractList list) {
        if (this.inventory.inventory.isEmpty()) {
            return null;
        }
        switch (mode) {
            case IGNORE: {
                return this.inventory.getItemsAt(0, 0, size);
            }
        }
        return this.inventory.getItemsExtractList(mode, list, size);
    }

    public ItemStack peekFirstStack(TileEntityExtractPort.EnumListMode mode, InventoryExtractList list) {
        if (this.inventory.inventory.isEmpty()) {
            return null;
        }
        switch (mode) {
            case IGNORE: {
                ItemGroup g = this.inventory.inventory.get(0);
                int count = (int)Math.min((long)g.itemStack.func_77976_d(), g.count);
                ItemStack ret = g.itemStack.func_77946_l();
                ret.field_77994_a = count;
                return ret;
            }
        }
        return this.inventory.peekItemsExtractList(mode, list);
    }

    public void sortInventory() {
        if (!this.field_145850_b.field_72995_K) {
            this.inventory.sort();
            this.updateInventory();
        }
    }

    public void updateInventory() {
        this.updateTileEntity();
        EZStorage.nw.sendToDimension((IMessage)new MessageFilterUpdate(this), this.field_145850_b.field_73011_w.getDimension());
    }

    public void updateTileEntity() {
        EZStorageUtils.notifyBlockUpdate(this);
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.slotCount(); ++i) {
            ItemGroup group = this.inventory.inventory.get(i);
            if (group == null || group.itemStack == null || group.count <= 0L) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Index", (byte)i);
            group.itemStack.func_77955_b(tag);
            tag.func_74772_a("InternalCount", group.count);
            nbttaglist.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Internal", (NBTBase)nbttaglist);
        nbt.func_74772_a("InternalMax", this.inventory.maxItems);
        nbt.func_74757_a("hasSearchBox", this.hasSearchBox);
        nbt.func_74757_a("isDisabled", this.disabled);
        nbt.func_74768_a("sortMode", this.sortMode.ordinal());
        nbt.func_74757_a("hasSortBox", this.hasSortBox);
        return nbt;
    }

    @Override
    public void readDataFromNBT(NBTTagCompound nbt) {
        long maxItems;
        NBTTagList nbttaglist = nbt.func_150295_c("Internal", 10);
        if (nbttaglist != null) {
            this.inventory.inventory = new ArrayList<ItemGroup>();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound tag = nbttaglist.func_150305_b(i);
                int j = tag.func_74771_c("Index") & 0xFF;
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
                long count = tag.func_74763_f("InternalCount");
                ItemGroup group = new ItemGroup(stack, count);
                this.inventory.inventory.add(group);
            }
        }
        this.inventory.maxItems = maxItems = nbt.func_74763_f("InternalMax");
        this.hasSearchBox = nbt.func_74767_n("hasSearchBox");
        this.disabled = nbt.func_74767_n("isDisabled");
        this.sortMode = ItemGroup.EnumSortMode.fromInt(nbt.func_74762_e("sortMode"));
        this.hasSortBox = nbt.func_74767_n("hasSortBox");
    }

    public void scanMultiblock() {
        this.inventory.maxItems = 0L;
        this.hasCraftBox = false;
        this.hasSearchBox = false;
        this.hasSortBox = false;
        this.multiblock = new HashSet<BlockRef>();
        BlockRef ref = new BlockRef(this);
        this.multiblock.add(ref);
        this.getValidNeighbors(ref);
        for (BlockRef blockRef : this.multiblock) {
            if (!(blockRef.block instanceof BlockStorage)) continue;
            BlockStorage sb = (BlockStorage)blockRef.block;
            this.inventory.maxItems += (long)sb.getCapacity();
        }
        EZStorageUtils.notifyBlockUpdate(this);
    }

    private void getValidNeighbors(BlockRef br) {
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.pos.func_177958_n(), br.pos.func_177956_o(), br.pos.func_177952_p(), this.field_145850_b);
        for (BlockRef blockRef : neighbors) {
            TileEntityBase entity;
            if (!(blockRef.block instanceof StorageMultiblock) || !this.multiblock.add(blockRef) || !this.validateSystem()) continue;
            if (blockRef.block instanceof BlockInputPort) {
                entity = (TileEntityInputPort)this.field_145850_b.func_175625_s(blockRef.pos);
                entity.core = this;
            }
            if (blockRef.block instanceof BlockOutputPort) {
                entity = (TileEntityEjectPort)this.field_145850_b.func_175625_s(blockRef.pos);
                ((TileEntityEjectPort)entity).core = this;
            }
            if (blockRef.block instanceof BlockExtractPort) {
                entity = (TileEntityExtractPort)this.field_145850_b.func_175625_s(blockRef.pos);
                ((TileEntityExtractPort)entity).core = this;
            }
            if (blockRef.block instanceof BlockCraftingBox) {
                this.hasCraftBox = true;
            }
            if (blockRef.block instanceof BlockSearchBox) {
                this.hasSearchBox = true;
            }
            if (blockRef.block instanceof BlockSortBox) {
                this.hasSortBox = true;
            }
            this.getValidNeighbors(blockRef);
        }
    }

    public boolean validateSystem() {
        int count = 0;
        for (BlockRef ref : this.multiblock) {
            if (ref.block instanceof BlockStorageCore) {
                ++count;
            }
            if (count <= 1) continue;
            if (this.field_145850_b.field_72995_K) {
                if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("You can only have 1 Storage Core per system!"));
                }
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == EZBlocks.storage_core) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), new ItemStack((Block)EZBlocks.storage_core)));
            }
            return false;
        }
        return true;
    }

    public boolean isPartOfMultiblock(BlockRef blockRef) {
        return this.multiblock != null && this.multiblock.contains(blockRef);
    }

    public void func_73660_a() {
        if (!this.firstTick && this.field_145850_b != null) {
            this.firstTick = true;
            this.scanMultiblock();
        }
    }
}

