/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.network;

import com.zerofall.ezstorage.gui.server.ContainerStorageCoreCrafting;
import com.zerofall.ezstorage.network.MessageCraftingSync;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.oredict.OreDictionary;

public class MessageRecipeSync
implements IMessage {
    private NBTTagCompound recipe;

    public MessageRecipeSync() {
    }

    public MessageRecipeSync(NBTTagCompound recipe) {
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipe = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.recipe);
    }

    public static class Handler
    implements IMessageHandler<MessageRecipeSync, MessageCraftingSync> {
        ItemStack[][] recipe;

        public MessageCraftingSync onMessage(MessageRecipeSync message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof ContainerStorageCoreCrafting) {
                ContainerStorageCoreCrafting con = (ContainerStorageCoreCrafting)container;
                TileEntityStorageCore tileEntity = con.tileEntity;
                con.clearGrid((EntityPlayer)player);
                this.recipe = new ItemStack[9][];
                for (int x = 0; x < this.recipe.length; ++x) {
                    NBTTagList list = message.recipe.func_150295_c("#" + x, 10);
                    if (list.func_74745_c() <= 0) continue;
                    NBTTagCompound tag = list.func_150305_b(0);
                    boolean hasOre = tag.func_74764_b("ore");
                    if (hasOre) {
                        List items = OreDictionary.getOres((String)tag.func_74779_i("ore"));
                        this.recipe[x] = new ItemStack[items.size()];
                        for (int y = 0; y < items.size(); ++y) {
                            this.recipe[x][y] = ((ItemStack)items.get(y)).func_77946_l();
                        }
                        continue;
                    }
                    this.recipe[x] = new ItemStack[list.func_74745_c()];
                    for (int y = 0; y < list.func_74745_c(); ++y) {
                        this.recipe[x][y] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(y));
                    }
                }
                for (int i = 0; i < this.recipe.length; ++i) {
                    ItemStack retreived;
                    Slot slot;
                    if (this.recipe[i] == null || this.recipe[i].length <= 0 || (slot = con.func_75147_a((IInventory)con.craftMatrix, i)) == null || (retreived = tileEntity.inventory.getItems(this.recipe[i])) == null) continue;
                    slot.func_75215_d(retreived);
                }
                tileEntity.sortInventory();
                return new MessageCraftingSync(con.craftMatrix);
            }
            return null;
        }
    }
}

