/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.proxy;

import exter.substratum.block.BlockDustOre;
import exter.substratum.block.BlockMetal;
import exter.substratum.block.BlockMetalSlab;
import exter.substratum.block.BlockOre;
import exter.substratum.block.SubstratumBlocks;
import exter.substratum.config.SubstratumConfig;
import exter.substratum.fluid.SubstratumFluids;
import exter.substratum.item.SubstratumItems;
import exter.substratum.material.EnumDyePowderColor;
import exter.substratum.material.EnumMaterial;
import exter.substratum.material.EnumMaterialItem;
import exter.substratum.proxy.CommonProxy;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;

public class ClientProxy
extends CommonProxy {
    private void registerItemModel(Block block, String name, int meta) {
        this.registerItemModel(Item.func_150898_a((Block)block), name, meta);
    }

    private void registerItemModel(Item item, String name, int meta) {
        name = "substratum:" + name;
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(name, "inventory"));
    }

    private void registerItemModel(Item item, String name) {
        name = "substratum:" + name;
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, (ItemMeshDefinition)new SimpleItemMeshDefinition(new ModelResourceLocation(name, "inventory")));
    }

    private void registerFluidModel(Fluid fluid, String name) {
        Block block = fluid.getBlock();
        Item item = Item.func_150898_a((Block)block);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new SimpleItemMeshDefinition(new ModelResourceLocation("substratum:" + name)));
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
    }

    @Override
    public void preInit() {
        this.registerFluidModel(SubstratumFluids.liquid_redstone, "liquidRedstone");
        this.registerFluidModel(SubstratumFluids.liquid_glowstone, "liquidGlowstone");
        this.registerFluidModel(SubstratumFluids.liquid_enderpearl, "liquidEnderpearl");
    }

    private void registerEquipment(Map<EnumMaterial, ? extends Item> map, String prefix) {
        for (Map.Entry<EnumMaterial, ? extends Item> e : map.entrySet()) {
            this.registerItemModel(e.getValue(), prefix + e.getKey().suffix);
        }
    }

    @Override
    public void init() {
        for (BlockOre.EnumVariant enumVariant : BlockOre.EnumVariant.values()) {
            this.registerItemModel(SubstratumBlocks.block_ore, "ore" + enumVariant.material.suffix, enumVariant.ordinal());
        }
        for (Enum enum_ : BlockDustOre.EnumVariant.values()) {
            this.registerItemModel(SubstratumBlocks.block_ore_dust, "ore" + ((BlockDustOre.EnumVariant)enum_).material.suffix, enum_.ordinal());
        }
        for (BlockMetal blockMetal : SubstratumBlocks.block_metal) {
            for (BlockMetal.Variant variant : blockMetal.getVariants()) {
                this.registerItemModel(blockMetal, "block" + variant.material.suffix, variant.id);
            }
        }
        for (BlockMetalSlab blockMetalSlab : SubstratumBlocks.block_slab) {
            for (BlockMetalSlab.Variant variant : blockMetalSlab.getVariants()) {
                this.registerItemModel((Block)blockMetalSlab, "slab" + variant.material.suffix, blockMetalSlab.getBottomVariantMeta(variant));
            }
        }
        for (Map.Entry entry : SubstratumBlocks.stairs_stacks.entrySet()) {
            ItemStack item = (ItemStack)entry.getValue();
            this.registerItemModel(item.func_77973_b(), "stairs" + ((EnumMaterial)((Object)entry.getKey())).suffix, item.func_77960_j());
        }
        for (EnumMaterialItem enumMaterialItem : EnumMaterialItem.values()) {
            for (EnumMaterial enumMaterial : EnumMaterial.values()) {
                ItemStack item = SubstratumItems.getStack(enumMaterialItem, enumMaterial, false);
                if (item == null) continue;
                this.registerItemModel(item.func_77973_b(), enumMaterialItem.prefix + enumMaterial.suffix, item.func_77960_j());
            }
        }
        if (SubstratumConfig.dye_enabled) {
            for (EnumDyePowderColor enumDyePowderColor : EnumDyePowderColor.values()) {
                this.registerItemModel(SubstratumItems.item_dye_powder, enumDyePowderColor.oredict, enumDyePowderColor.ordinal());
                this.registerItemModel(SubstratumItems.item_dye_powder_small, enumDyePowderColor.oredict_small, enumDyePowderColor.ordinal());
            }
        }
        if (SubstratumItems.item_mortar != null) {
            this.registerItemModel(SubstratumItems.item_mortar, "mortar");
        }
        this.registerEquipment(SubstratumItems.pickaxes, "pickaxe");
        this.registerEquipment(SubstratumItems.axes, "axe");
        this.registerEquipment(SubstratumItems.shovels, "shovel");
        this.registerEquipment(SubstratumItems.hoes, "hoe");
        this.registerEquipment(SubstratumItems.swords, "sword");
        this.registerEquipment(SubstratumItems.helmets, "helmet");
        this.registerEquipment(SubstratumItems.chestplates, "chestplate");
        this.registerEquipment(SubstratumItems.leggings, "leggings");
        this.registerEquipment(SubstratumItems.boots, "boots");
    }

    @Override
    public void postInit() {
    }

    private static class SimpleItemMeshDefinition
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public SimpleItemMeshDefinition(ModelResourceLocation location) {
            this.location = location;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.location;
        }
    }
}

