/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.item;

import exter.substratum.config.SubstratumConfig;
import exter.substratum.handler.BucketSpecialHandler;
import exter.substratum.handler.FluidSpecialHandler;
import exter.substratum.item.ItemDyePowder;
import exter.substratum.item.ItemDyePowderSmall;
import exter.substratum.item.ItemMaterial;
import exter.substratum.item.ItemMortar;
import exter.substratum.item.equipment.ItemArmorSubstratum;
import exter.substratum.item.equipment.ItemAxeSubstratum;
import exter.substratum.item.equipment.ItemHoeSubstratum;
import exter.substratum.item.equipment.ItemPickaxeSubstratum;
import exter.substratum.item.equipment.ItemShovelSubstratum;
import exter.substratum.item.equipment.ItemSwordSubstratum;
import exter.substratum.material.EnumDyePowderColor;
import exter.substratum.material.EnumMaterial;
import exter.substratum.material.EnumMaterialEquipment;
import exter.substratum.material.EnumMaterialItem;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class SubstratumItems {
    public static Map<EnumMaterialItem, ItemMaterial> item_materials = new EnumMap<EnumMaterialItem, ItemMaterial>(EnumMaterialItem.class);
    public static ItemMortar item_mortar = null;
    public static ItemDyePowder item_dye_powder = null;
    public static ItemDyePowderSmall item_dye_powder_small = null;
    private static Map<MaterialItem, ItemStack> vanilla_items;
    public static Map<EnumMaterial, ItemPickaxeSubstratum> pickaxes;
    public static Map<EnumMaterial, ItemAxeSubstratum> axes;
    public static Map<EnumMaterial, ItemShovelSubstratum> shovels;
    public static Map<EnumMaterial, ItemHoeSubstratum> hoes;
    public static Map<EnumMaterial, ItemSwordSubstratum> swords;
    public static Map<EnumMaterial, ItemArmorSubstratum> helmets;
    public static Map<EnumMaterial, ItemArmorSubstratum> chestplates;
    public static Map<EnumMaterial, ItemArmorSubstratum> leggings;
    public static Map<EnumMaterial, ItemArmorSubstratum> boots;

    public static void registerItems(Configuration config) {
        for (EnumMaterialItem matitem : EnumMaterialItem.values()) {
            ItemMaterial item = new ItemMaterial(matitem);
            item_materials.put(matitem, item);
            GameRegistry.register((IForgeRegistryEntry)item);
            for (EnumMaterial mat : matitem.materials) {
                OreDictionary.registerOre((String)(matitem.prefix + mat.suffix), (ItemStack)item.getStack(mat));
            }
        }
        for (ItemMaterial matitem : item_materials.values()) {
            ItemStack stack = matitem.getStack(EnumMaterial.ALUMINIUM);
            if (stack != null) {
                OreDictionary.registerOre((String)(matitem.item.prefix + "Aluminum"), (ItemStack)stack);
            }
            if ((stack = matitem.getStack(EnumMaterial.CHROMIUM)) == null) continue;
            OreDictionary.registerOre((String)(matitem.item.prefix + "Chromium"), (ItemStack)stack);
        }
        item_materials.get((Object)EnumMaterialItem.BUCKET_DUST).func_77642_a(Items.field_151133_ar).func_77625_d(1);
        item_materials.get((Object)EnumMaterialItem.BOTTLE_DUST).func_77642_a(Items.field_151069_bo);
        item_materials.get((Object)EnumMaterialItem.BUCKET_LIQUID).setSpecialHandler(new BucketSpecialHandler()).func_77642_a(Items.field_151133_ar).func_77625_d(1);
        item_materials.get((Object)EnumMaterialItem.BOTTLE_LIQUID).setSpecialHandler(new FluidSpecialHandler(250)).func_77642_a(Items.field_151069_bo);
        item_materials.get((Object)EnumMaterialItem.BUCKET_LIQUID);
        if (SubstratumConfig.misc_mortar_uses > 0) {
            item_mortar = new ItemMortar(SubstratumConfig.misc_mortar_uses);
            GameRegistry.register((IForgeRegistryEntry)item_mortar);
        }
        if (SubstratumConfig.dye_enabled) {
            item_dye_powder = new ItemDyePowder();
            item_dye_powder_small = new ItemDyePowderSmall();
            GameRegistry.register((IForgeRegistryEntry)item_dye_powder);
            GameRegistry.register((IForgeRegistryEntry)item_dye_powder_small);
            for (EnumDyePowderColor color : EnumDyePowderColor.values()) {
                OreDictionary.registerOre((String)color.oredict, (ItemStack)item_dye_powder.getStack(color));
                OreDictionary.registerOre((String)color.oredict_small, (ItemStack)item_dye_powder_small.getStack(color));
                OreDictionary.registerOre((String)color.oredict_dust, (ItemStack)item_dye_powder.getStack(color));
                OreDictionary.registerOre((String)color.oredict_dust_small, (ItemStack)item_dye_powder_small.getStack(color));
            }
        }
        OreDictionary.registerOre((String)"dustGunpowder", (ItemStack)new ItemStack(Items.field_151016_H));
        OreDictionary.registerOre((String)"dustBlaze", (ItemStack)new ItemStack(Items.field_151065_br));
        vanilla_items = new HashMap<MaterialItem, ItemStack>();
        vanilla_items.put(new MaterialItem(EnumMaterialItem.INGOT, EnumMaterial.IRON), new ItemStack(Items.field_151042_j));
        vanilla_items.put(new MaterialItem(EnumMaterialItem.INGOT, EnumMaterial.GOLD), new ItemStack(Items.field_151043_k));
        vanilla_items.put(new MaterialItem(EnumMaterialItem.NUGGET, EnumMaterial.GOLD), new ItemStack(Items.field_151074_bl));
        vanilla_items.put(new MaterialItem(EnumMaterialItem.DUST, EnumMaterial.REDSTONE), new ItemStack(Items.field_151137_ax));
        vanilla_items.put(new MaterialItem(EnumMaterialItem.DUST, EnumMaterial.GLOWSTONE), new ItemStack(Items.field_151114_aO));
        vanilla_items.put(new MaterialItem(EnumMaterialItem.DUST, EnumMaterial.GUNPOWDER), new ItemStack(Items.field_151016_H));
        vanilla_items.put(new MaterialItem(EnumMaterialItem.DUST, EnumMaterial.BLAZE), new ItemStack(Items.field_151065_br));
        for (EnumMaterialEquipment equipment : EnumMaterialEquipment.values()) {
            Object item;
            equipment.tool.setRepairItem(SubstratumItems.getStack(EnumMaterialItem.INGOT, equipment.material));
            SubstratumConfig.MaterialRecipeConfig mat_config = SubstratumConfig.material_recipes.get((Object)equipment.material);
            if (mat_config.tool_pickaxe) {
                item = new ItemPickaxeSubstratum(equipment);
                GameRegistry.register((IForgeRegistryEntry)item);
                pickaxes.put(equipment.material, (ItemPickaxeSubstratum)((Object)item));
                OreDictionary.registerOre((String)("pickaxe" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (mat_config.tool_axe) {
                item = new ItemAxeSubstratum(equipment);
                GameRegistry.register((IForgeRegistryEntry)item);
                axes.put(equipment.material, (ItemAxeSubstratum)((Object)item));
                OreDictionary.registerOre((String)("axe" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (mat_config.tool_shovel) {
                item = new ItemShovelSubstratum(equipment);
                GameRegistry.register((IForgeRegistryEntry)item);
                shovels.put(equipment.material, (ItemShovelSubstratum)((Object)item));
                OreDictionary.registerOre((String)("shovel" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (mat_config.tool_hoe) {
                item = new ItemHoeSubstratum(equipment);
                GameRegistry.register((IForgeRegistryEntry)item);
                hoes.put(equipment.material, (ItemHoeSubstratum)((Object)item));
                OreDictionary.registerOre((String)("hoe" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (mat_config.tool_sword) {
                item = new ItemSwordSubstratum(equipment);
                GameRegistry.register((IForgeRegistryEntry)item);
                swords.put(equipment.material, (ItemSwordSubstratum)((Object)item));
                OreDictionary.registerOre((String)("sword" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (mat_config.armor_helmet) {
                item = new ItemArmorSubstratum(equipment, EntityEquipmentSlot.HEAD);
                GameRegistry.register((IForgeRegistryEntry)item);
                helmets.put(equipment.material, (ItemArmorSubstratum)((Object)item));
                OreDictionary.registerOre((String)("helmet" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (mat_config.armor_chestplate) {
                item = new ItemArmorSubstratum(equipment, EntityEquipmentSlot.CHEST);
                GameRegistry.register((IForgeRegistryEntry)item);
                chestplates.put(equipment.material, (ItemArmorSubstratum)((Object)item));
                OreDictionary.registerOre((String)("chestplate" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (mat_config.armor_leggings) {
                item = new ItemArmorSubstratum(equipment, EntityEquipmentSlot.LEGS);
                GameRegistry.register((IForgeRegistryEntry)item);
                leggings.put(equipment.material, (ItemArmorSubstratum)((Object)item));
                OreDictionary.registerOre((String)("leggings" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
            }
            if (!mat_config.armor_boots) continue;
            item = new ItemArmorSubstratum(equipment, EntityEquipmentSlot.FEET);
            GameRegistry.register((IForgeRegistryEntry)item);
            boots.put(equipment.material, (ItemArmorSubstratum)((Object)item));
            OreDictionary.registerOre((String)("boots" + equipment.material.suffix), (ItemStack)new ItemStack((Item)item, 1, 0));
        }
    }

    public static ItemStack getStack(EnumMaterialItem item, EnumMaterial material) {
        return SubstratumItems.getStack(item, material, 1, true);
    }

    public static ItemStack getStack(EnumMaterialItem item, EnumMaterial material, int amount) {
        return SubstratumItems.getStack(item, material, amount, true);
    }

    public static ItemStack getStack(EnumMaterialItem item, EnumMaterial material, boolean vanilla) {
        return SubstratumItems.getStack(item, material, 1, vanilla);
    }

    public static ItemStack getStack(EnumMaterialItem item, EnumMaterial material, int amount, boolean vanilla) {
        ItemStack stack;
        if (vanilla && (stack = vanilla_items.get(new MaterialItem(item, material))) != null) {
            stack = stack.func_77946_l();
            stack.field_77994_a = amount;
            return stack;
        }
        return item_materials.get((Object)item).getStack(material, amount);
    }

    static {
        pickaxes = new EnumMap<EnumMaterial, ItemPickaxeSubstratum>(EnumMaterial.class);
        axes = new EnumMap<EnumMaterial, ItemAxeSubstratum>(EnumMaterial.class);
        shovels = new EnumMap<EnumMaterial, ItemShovelSubstratum>(EnumMaterial.class);
        hoes = new EnumMap<EnumMaterial, ItemHoeSubstratum>(EnumMaterial.class);
        swords = new EnumMap<EnumMaterial, ItemSwordSubstratum>(EnumMaterial.class);
        helmets = new EnumMap<EnumMaterial, ItemArmorSubstratum>(EnumMaterial.class);
        chestplates = new EnumMap<EnumMaterial, ItemArmorSubstratum>(EnumMaterial.class);
        leggings = new EnumMap<EnumMaterial, ItemArmorSubstratum>(EnumMaterial.class);
        boots = new EnumMap<EnumMaterial, ItemArmorSubstratum>(EnumMaterial.class);
    }

    private static class MaterialItem {
        public final EnumMaterialItem item;
        public final EnumMaterial material;

        public MaterialItem(EnumMaterialItem item, EnumMaterial material) {
            this.item = item;
            this.material = material;
        }

        public int hashCode() {
            return this.item.ordinal() * 256 + this.material.ordinal();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MaterialItem other = (MaterialItem)obj;
            if (this.item != other.item) {
                return false;
            }
            return this.material == other.material;
        }
    }
}

