/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.init;

import exter.substratum.block.SubstratumBlocks;
import exter.substratum.config.SubstratumConfig;
import exter.substratum.init.InitBlendRecipes;
import exter.substratum.init.InitEquipmentRecipes;
import exter.substratum.item.SubstratumItems;
import exter.substratum.material.EnumDyePowderColor;
import exter.substratum.material.EnumMaterial;
import exter.substratum.material.EnumMaterialItem;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class InitRecipes {
    private static void addDyeMix(EnumDyePowderColor result, String ... ingredients) {
        int i;
        Object[] ing_oredict = new Object[ingredients.length];
        for (i = 0; i < ingredients.length; ++i) {
            ing_oredict[i] = "dustDye" + ingredients[i];
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.item_dye_powder.getStack(result, ingredients.length), ing_oredict));
        for (i = 0; i < ingredients.length; ++i) {
            ing_oredict[i] = "dustSmallDye" + ingredients[i];
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.item_dye_powder_small.getStack(result, ingredients.length), ing_oredict));
    }

    private static void initLegacy() {
        GameRegistry.addShapelessRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.DUST, EnumMaterial.REDSTONE, 10), (Object[])new Object[]{SubstratumItems.getStack(EnumMaterialItem.BUCKET_DUST, EnumMaterial.REDSTONE)});
        GameRegistry.addShapelessRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.DUST, EnumMaterial.GLOWSTONE, 4), (Object[])new Object[]{SubstratumItems.getStack(EnumMaterialItem.BUCKET_DUST, EnumMaterial.GLOWSTONE)});
        GameRegistry.addShapelessRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.DUST, EnumMaterial.ENDERPEARL, 4), (Object[])new Object[]{SubstratumItems.getStack(EnumMaterialItem.BUCKET_DUST, EnumMaterial.ENDERPEARL)});
    }

    public static void init() {
        ItemStack ingot;
        ItemStack ingot2;
        InitBlendRecipes.init();
        InitEquipmentRecipes.init();
        if (SubstratumConfig.alumina_nugget_smelting) {
            GameRegistry.addSmelting((ItemStack)SubstratumItems.getStack(EnumMaterialItem.NUGGET, EnumMaterial.ALUMINA), (ItemStack)SubstratumItems.getStack(EnumMaterialItem.NUGGET, EnumMaterial.ALUMINIUM), (float)0.0f);
        }
        if (SubstratumItems.item_mortar != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)SubstratumItems.item_mortar), (Object[])new Object[]{"  T", " F ", " S ", Character.valueOf('F'), new ItemStack(Items.field_151145_ak), Character.valueOf('T'), new ItemStack(Items.field_151055_y), Character.valueOf('S'), new ItemStack(Blocks.field_150348_b)});
            ItemStack mortar = new ItemStack((Item)SubstratumItems.item_mortar, 1, Short.MAX_VALUE);
            if (SubstratumConfig.material_recipes.get((Object)((Object)EnumMaterial.COAL)).dust_from_ingot) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.DUST, EnumMaterial.COAL), new Object[]{mortar, new ItemStack(Items.field_151044_h, 1, 0)}));
            }
            if (SubstratumConfig.material_recipes.get((Object)((Object)EnumMaterial.CHARCOAL)).dust_from_ingot) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.DUST, EnumMaterial.CHARCOAL), new Object[]{mortar, new ItemStack(Items.field_151044_h, 1, 1)}));
            }
            if (SubstratumConfig.material_recipes.get((Object)((Object)EnumMaterial.OBSIDIAN)).dust_from_ingot) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.DUST, EnumMaterial.OBSIDIAN, 2), new Object[]{mortar, new ItemStack(Blocks.field_150343_Z)}));
            }
            if (SubstratumConfig.material_recipes.get((Object)((Object)EnumMaterial.ENDERPEARL)).dust_from_ingot) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.DUST, EnumMaterial.ENDERPEARL), new Object[]{mortar, new ItemStack(Items.field_151079_bi)}));
            }
            for (EnumMaterial mat : EnumMaterialItem.DUST.materials) {
                if (SubstratumItems.getStack(EnumMaterialItem.INGOT, mat) == null || !SubstratumConfig.material_recipes.get((Object)((Object)mat)).dust_from_ingot) continue;
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.DUST, mat), new Object[]{mortar, "ingot" + mat.suffix}));
            }
            if (SubstratumConfig.dye_enabled) {
                for (EnumDyePowderColor color : EnumDyePowderColor.values()) {
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.item_dye_powder.getStack(color), new Object[]{mortar, color.oredict}));
                }
            }
        }
        for (EnumMaterial mat : EnumMaterialItem.DUST_SMALL.materials) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(SubstratumItems.getStack(EnumMaterialItem.DUST_SMALL, mat, 4), new Object[]{"  ", " D", Character.valueOf('D'), "dust" + mat.suffix}));
            GameRegistry.addRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.DUST, mat), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), SubstratumItems.getStack(EnumMaterialItem.DUST_SMALL, mat)});
        }
        if (SubstratumConfig.dye_enabled) {
            for (EnumDyePowderColor color : EnumDyePowderColor.values()) {
                GameRegistry.addRecipe((ItemStack)SubstratumItems.item_dye_powder_small.getStack(color, 4), (Object[])new Object[]{"  ", " D", Character.valueOf('D'), SubstratumItems.item_dye_powder.getStack(color)});
                GameRegistry.addRecipe((ItemStack)SubstratumItems.item_dye_powder.getStack(color), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), SubstratumItems.item_dye_powder_small.getStack(color)});
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)Blocks.field_150399_cn, 2, color.dye.func_176765_a()), new Object[]{color.oredict_small, Blocks.field_150359_w, Blocks.field_150359_w}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Blocks.field_150406_ce, 2, color.dye.func_176765_a()), new Object[]{color.oredict_small, Blocks.field_150405_ch, Blocks.field_150405_ch}));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)Blocks.field_150397_co, 5, color.dye.func_176765_a()), new Object[]{color.oredict_small, Blocks.field_150410_aZ, Blocks.field_150410_aZ, Blocks.field_150410_aZ, Blocks.field_150410_aZ, Blocks.field_150410_aZ}));
            }
            InitRecipes.addDyeMix(EnumDyePowderColor.LIGHT_GRAY, "White", "Gray");
            InitRecipes.addDyeMix(EnumDyePowderColor.LIGHT_GRAY, "Black", "White", "White");
            InitRecipes.addDyeMix(EnumDyePowderColor.GRAY, "Black", "White");
            InitRecipes.addDyeMix(EnumDyePowderColor.ORANGE, "Red", "Yellow");
            InitRecipes.addDyeMix(EnumDyePowderColor.LIME, "Green", "White");
            InitRecipes.addDyeMix(EnumDyePowderColor.LIGHT_BLUE, "Blue", "White");
            InitRecipes.addDyeMix(EnumDyePowderColor.PINK, "Red", "White");
            InitRecipes.addDyeMix(EnumDyePowderColor.CYAN, "Green", "Blue");
            InitRecipes.addDyeMix(EnumDyePowderColor.PURPLE, "Red", "Blue");
            InitRecipes.addDyeMix(EnumDyePowderColor.MAGENTA, "Pink", "Purple");
            InitRecipes.addDyeMix(EnumDyePowderColor.MAGENTA, "White", "Red", "Red", "Blue");
            InitRecipes.addDyeMix(EnumDyePowderColor.MAGENTA, "Pink", "Red", "Blue");
            InitRecipes.addDyeMix(EnumDyePowderColor.BROWN, "Black", "Red", "Yellow");
            InitRecipes.addDyeMix(EnumDyePowderColor.BROWN, "Black", "Orange");
        }
        ItemStack bucket = new ItemStack(Items.field_151133_ar);
        ItemStack bottle = new ItemStack(Items.field_151069_bo);
        if (SubstratumConfig.material_recipes.get((Object)((Object)EnumMaterial.REDSTONE)).dust_bottle) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.BOTTLE_DUST, EnumMaterial.REDSTONE), new Object[]{bottle, "dustRedstone", "dustRedstone", "dustSmallRedstone", "dustSmallRedstone"}));
        }
        if (SubstratumConfig.material_recipes.get((Object)((Object)EnumMaterial.GLOWSTONE)).dust_bottle) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.BOTTLE_DUST, EnumMaterial.GLOWSTONE), new Object[]{bottle, "dustGlowstone"}));
        }
        if (SubstratumConfig.material_recipes.get((Object)((Object)EnumMaterial.ENDERPEARL)).dust_bottle) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.BOTTLE_DUST, EnumMaterial.ENDERPEARL), new Object[]{bottle, "dustEnderpearl"}));
        }
        for (EnumMaterial mat : EnumMaterialItem.BUCKET_LIQUID.materials) {
            ItemStack liquid_bucket = SubstratumItems.getStack(EnumMaterialItem.BUCKET_LIQUID, mat);
            ItemStack liquid_bottle = SubstratumItems.getStack(EnumMaterialItem.BOTTLE_LIQUID, mat);
            ItemStack dust_bottle = SubstratumItems.getStack(EnumMaterialItem.BOTTLE_DUST, mat);
            if (dust_bottle != null && SubstratumConfig.material_recipes.get((Object)((Object)mat)).dust_bottle) {
                GameRegistry.addSmelting((ItemStack)dust_bottle, (ItemStack)liquid_bottle, (float)0.0f);
            }
            if (liquid_bottle == null) continue;
            GameRegistry.addShapelessRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.BOTTLE_LIQUID, mat, 4), (Object[])new Object[]{liquid_bucket, bottle, bottle, bottle, bottle});
            GameRegistry.addShapelessRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.BUCKET_LIQUID, mat), (Object[])new Object[]{bucket, liquid_bottle, liquid_bottle, liquid_bottle, liquid_bottle});
        }
        for (EnumMaterial mat : EnumMaterialItem.DUST.materials) {
            ingot2 = SubstratumItems.getStack(EnumMaterialItem.INGOT, mat);
            if (ingot2 == null || !SubstratumConfig.material_recipes.get((Object)((Object)mat)).ingot_from_dust) continue;
            GameRegistry.addSmelting((ItemStack)SubstratumItems.getStack(EnumMaterialItem.DUST, mat), (ItemStack)ingot2, (float)0.0f);
        }
        for (EnumMaterial mat : EnumMaterialItem.NUGGET.materials) {
            ingot2 = SubstratumItems.getStack(EnumMaterialItem.INGOT, mat);
            GameRegistry.addShapelessRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.NUGGET, mat, 9), (Object[])new Object[]{ingot2});
            GameRegistry.addRecipe((ItemStack)ingot2, (Object[])new Object[]{"NNN", "NNN", "NNN", Character.valueOf('N'), SubstratumItems.getStack(EnumMaterialItem.NUGGET, mat)});
        }
        for (Map.Entry entry : SubstratumBlocks.block_stacks.entrySet()) {
            ItemStack block = (ItemStack)entry.getValue();
            EnumMaterial mat = (EnumMaterial)((Object)entry.getKey());
            GameRegistry.addShapelessRecipe((ItemStack)SubstratumItems.getStack(EnumMaterialItem.INGOT, mat, 9), (Object[])new Object[]{block});
            GameRegistry.addRecipe((ItemStack)block, (Object[])new Object[]{"III", "III", "III", Character.valueOf('I'), SubstratumItems.getStack(EnumMaterialItem.INGOT, mat)});
        }
        for (Map.Entry metal : SubstratumBlocks.ore_stacks.entrySet()) {
            ingot2 = SubstratumItems.getStack(EnumMaterialItem.INGOT, (EnumMaterial)((Object)metal.getKey()));
            if (ingot2 == null) continue;
            GameRegistry.addSmelting((ItemStack)((ItemStack)metal.getValue()), (ItemStack)ingot2, (float)0.0f);
        }
        ItemStack stick = new ItemStack(Items.field_151055_y);
        ItemStack stone = new ItemStack(Blocks.field_150347_e);
        for (EnumMaterial mat : EnumMaterialItem.GEAR.materials) {
            if (!SubstratumConfig.material_recipes.get((Object)((Object)mat)).gear_crafting) continue;
            if (mat == EnumMaterial.STONE) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(SubstratumItems.getStack(EnumMaterialItem.GEAR, mat), new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), stone, Character.valueOf('S'), stick}));
                continue;
            }
            if (SubstratumConfig.cheaper_gear_recipes) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(SubstratumItems.getStack(EnumMaterialItem.GEAR, mat), new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), "ingot" + mat.suffix, Character.valueOf('S'), stick}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(SubstratumItems.getStack(EnumMaterialItem.GEAR, mat), new Object[]{" P ", "PIP", " P ", Character.valueOf('P'), "plate" + mat.suffix, Character.valueOf('I'), "ingot" + mat.suffix}));
            }
            if (!SubstratumConfig.material_recipes.get((Object)((Object)mat)).ingots_from_gear || (ingot = SubstratumItems.getStack(EnumMaterialItem.INGOT, mat, 4)) == null) continue;
            GameRegistry.addSmelting((ItemStack)SubstratumItems.getStack(EnumMaterialItem.GEAR, mat), (ItemStack)ingot, (float)0.0f);
        }
        for (Map.Entry entry : SubstratumBlocks.slab_stacks.entrySet()) {
            if (!SubstratumConfig.material_recipes.get(entry.getKey()).slab_from_blocks) continue;
            ItemStack slabs = ((ItemStack)entry.getValue()).func_77946_l();
            slabs.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(slabs, new Object[]{"BB", Character.valueOf('B'), "block" + ((EnumMaterial)((Object)entry.getKey())).suffix}));
        }
        for (Map.Entry entry : SubstratumBlocks.stairs_stacks.entrySet()) {
            if (!SubstratumConfig.material_recipes.get(entry.getKey()).stairs_from_blocks) continue;
            ItemStack stairs = ((ItemStack)entry.getValue()).func_77946_l();
            stairs.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stairs, new Object[]{" B", "BB", Character.valueOf('B'), "block" + ((EnumMaterial)((Object)entry.getKey())).suffix}));
        }
        for (EnumMaterial mat : EnumMaterialItem.PLATE.materials) {
            if (SubstratumConfig.material_recipes.get((Object)((Object)mat)).plate_crafting) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(SubstratumItems.getStack(EnumMaterialItem.PLATE, mat, SubstratumConfig.cheaper_plate_recipes ? 3 : 2), new Object[]{"III", "   ", "   ", Character.valueOf('I'), "ingot" + mat.suffix}));
            }
            if (!SubstratumConfig.material_recipes.get((Object)((Object)mat)).ingot_from_plate || (ingot = SubstratumItems.getStack(EnumMaterialItem.INGOT, mat)) == null) continue;
            GameRegistry.addSmelting((ItemStack)SubstratumItems.getStack(EnumMaterialItem.PLATE, mat), (ItemStack)ingot, (float)0.0f);
        }
        for (EnumMaterial mat : EnumMaterialItem.ROD.materials) {
            if (SubstratumConfig.material_recipes.get((Object)((Object)mat)).rod_crafting) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(SubstratumItems.getStack(EnumMaterialItem.ROD, mat, SubstratumConfig.cheaper_rod_recipes ? 6 : 4), new Object[]{"I  ", "I  ", "I  ", Character.valueOf('I'), "ingot" + mat.suffix}));
            }
            if (SubstratumItems.item_mortar == null || !SubstratumConfig.material_recipes.get((Object)((Object)mat)).dust_from_rod) continue;
            ItemStack mortar = new ItemStack((Item)SubstratumItems.item_mortar, 1, Short.MAX_VALUE);
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(SubstratumItems.getStack(EnumMaterialItem.DUST_SMALL, mat, 2), new Object[]{mortar, SubstratumItems.getStack(EnumMaterialItem.ROD, mat)}));
        }
        InitRecipes.initLegacy();
    }
}

