/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.handler;

import exter.substratum.block.BlockSubstratumLiquid;
import exter.substratum.fluid.SubstratumFluids;
import exter.substratum.item.ItemMaterial;
import exter.substratum.item.SubstratumItems;
import exter.substratum.material.EnumMaterial;
import exter.substratum.material.EnumMaterialItem;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SubstratumBucketHandler
implements ItemMaterial.IRightClickHandler {
    private final Map<String, ItemStack> buckets = new HashMap<String, ItemStack>();
    private final Map<EnumMaterial, Fluid> liquids;

    public SubstratumBucketHandler() {
        this.buckets.put(SubstratumFluids.liquid_redstone.getName(), SubstratumItems.getStack(EnumMaterialItem.BUCKET_LIQUID, EnumMaterial.REDSTONE));
        this.buckets.put(SubstratumFluids.liquid_glowstone.getName(), SubstratumItems.getStack(EnumMaterialItem.BUCKET_LIQUID, EnumMaterial.GLOWSTONE));
        this.buckets.put(SubstratumFluids.liquid_enderpearl.getName(), SubstratumItems.getStack(EnumMaterialItem.BUCKET_LIQUID, EnumMaterial.ENDERPEARL));
        this.liquids = new EnumMap<EnumMaterial, Fluid>(EnumMaterial.class);
        this.liquids.put(EnumMaterial.REDSTONE, SubstratumFluids.liquid_redstone);
        this.liquids.put(EnumMaterial.GLOWSTONE, SubstratumFluids.liquid_glowstone);
        this.liquids.put(EnumMaterial.ENDERPEARL, SubstratumFluids.liquid_enderpearl);
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillBucket(event.getWorld(), event.getTarget());
        if (result == null) {
            return;
        }
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    private ItemStack fillBucket(World world, RayTraceResult rt) {
        BlockSubstratumLiquid block;
        ItemStack bucket;
        if (rt == null) {
            return null;
        }
        BlockPos pos = rt.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSubstratumLiquid && (bucket = this.buckets.get((block = (BlockSubstratumLiquid)state.func_177230_c()).getFluid().getName())) != null && block.isSourceBlock((IBlockAccess)world, pos)) {
            world.func_175698_g(pos);
            return bucket.func_77946_l();
        }
        return null;
    }

    protected RayTraceResult getMovingObjectPositionFromPlayer(World world, EntityPlayer player) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        Vec3d vec3d = new Vec3d(x, y, z);
        float spitch = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float lx = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * spitch;
        float ly = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float lz = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * spitch;
        double range = 5.0;
        if (player instanceof EntityPlayerMP) {
            range = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec3d1 = vec3d.func_72441_c((double)lx * range, (double)ly * range, (double)lz * range);
        return world.func_147447_a(vec3d, vec3d1, false, true, false);
    }

    public boolean tryPlaceContainedLiquid(EnumMaterial material, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        boolean solid = !state.func_185904_a().func_76220_a();
        boolean replaceable = state.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || solid || replaceable)) {
            return false;
        }
        if (!world.field_72995_K && (solid || replaceable) && !state.func_185904_a().func_76224_d()) {
            world.func_175655_b(pos, true);
        }
        SoundEvent soundevent = SoundEvents.field_187627_L;
        world.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        world.func_180501_a(pos, this.liquids.get((Object)material).getBlock().func_176223_P(), 11);
        return true;
    }

    @Override
    public ActionResult<ItemStack> onRightClick(ItemStack stack, ItemMaterial item, EnumMaterial material, World world, EntityPlayer player, EnumHand hand) {
        BlockPos replace_pos;
        RayTraceResult raytraceresult = this.getMovingObjectPositionFromPlayer(world, player);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        if (!world.func_175660_a(player, pos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        boolean replaceable = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
        BlockPos blockPos = replace_pos = replaceable && raytraceresult.field_178784_b == EnumFacing.UP ? pos : pos.func_177972_a(raytraceresult.field_178784_b);
        if (!player.func_175151_a(replace_pos, raytraceresult.field_178784_b, stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.tryPlaceContainedLiquid(material, player, world, replace_pos)) {
            player.func_71029_a(StatList.func_188057_b((Item)item));
            return !player.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(Items.field_151133_ar)) : new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

