/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.block;

import com.google.common.base.Optional;
import exter.substratum.block.IBlockVariants;
import exter.substratum.creativetab.TabMaterials;
import exter.substratum.material.EnumMaterial;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMetalSlab
extends BlockSlab
implements IBlockVariants {
    private PropertyVariant property_variant;
    private BlockSlab single;

    public abstract Variant[] getVariants();

    public BlockMetalSlab(BlockSlab single, String name) {
        super(Material.field_151573_f);
        this.single = single;
        this.func_149647_a(TabMaterials.tab);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("substratum.slab" + (single != null ? "Double" : ""));
        this.setRegistryName(name);
        this.field_149783_u = true;
    }

    public final int func_180651_a(IBlockState state) {
        return ((Variant)state.func_177229_b(this.func_176551_l())).id;
    }

    public final Item func_180660_a(IBlockState blockState, Random random, int unused) {
        if (this.single != null) {
            return Item.func_150898_a((Block)this.single);
        }
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public final ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int amount = this.single == null ? 1 : 2;
        return new ItemStack(this.func_180660_a(state, null, 0), amount, this.func_180651_a(state));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List items) {
        if (!this.func_176552_j()) {
            for (Variant v : this.getVariants()) {
                items.add(new ItemStack(item, 1, v.id));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isSlab(Block b) {
        if (b instanceof BlockSlab) {
            return !((BlockSlab)b).func_176552_j();
        }
        return false;
    }

    public boolean func_149700_E() {
        return false;
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a() + ((Variant)this.func_176203_a((int)meta).func_177229_b(this.func_176551_l())).material.suffix;
    }

    public boolean func_176552_j() {
        return this.single != null;
    }

    public IProperty<Variant> func_176551_l() {
        if (this.property_variant == null) {
            this.property_variant = new PropertyVariant(this.getVariants());
        }
        return this.property_variant;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return this.getVariants()[stack.func_77960_j()];
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, this.func_176551_l()});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.func_176551_l(), (Comparable)this.getVariants()[meta & 7]).func_177226_a((IProperty)field_176554_a, (Comparable)((meta >>> 3 & 1) == 1 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        Variant var = (Variant)state.func_177229_b(this.func_176551_l());
        BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a);
        return var.id & 7 | (half == BlockSlab.EnumBlockHalf.TOP ? 1 : 0) << 3;
    }

    public IBlockState getBottomVariant(Variant v) {
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a(this.func_176551_l(), (Comparable)v);
    }

    public int getBottomVariantMeta(Variant v) {
        return this.func_176201_c(this.getBottomVariant(v));
    }

    private class PropertyVariant
    extends PropertyHelper<Variant> {
        private Map<String, Variant> variants;

        public PropertyVariant(Variant[] variants) {
            super("metal", Variant.class);
            int i = 0;
            this.variants = new HashMap<String, Variant>();
            for (Variant v : variants) {
                v.id = i++;
                this.variants.put(v.func_176610_l(), v);
            }
        }

        public Collection<Variant> func_177700_c() {
            return this.variants.values();
        }

        public String getName(Variant value) {
            return value.func_176610_l();
        }

        public Optional<Variant> func_185929_b(String value) {
            return Optional.fromNullable((Object)this.variants.get(value));
        }
    }

    public static class Variant
    implements IStringSerializable,
    Comparable<Variant> {
        public final EnumMaterial material;
        public int id;

        public Variant(EnumMaterial material) {
            this.material = material;
            this.id = -1;
        }

        public String func_176610_l() {
            return this.material.suffix.toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }

        @Override
        public int compareTo(Variant other) {
            return this.id - other.id;
        }
    }
}

