/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.block;

import com.google.common.base.Optional;
import exter.substratum.block.IBlockVariants;
import exter.substratum.creativetab.TabMaterials;
import exter.substratum.material.EnumMaterial;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMetal
extends Block
implements IBlockVariants {
    private PropertyVariant property_variant;

    public abstract Variant[] getVariants();

    public BlockMetal(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(8.0f);
        this.func_149663_c("substratum.block");
        this.setRegistryName(name);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(TabMaterials.tab);
    }

    protected BlockStateContainer func_180661_e() {
        if (this.property_variant == null) {
            this.property_variant = new PropertyVariant(this.getVariants());
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property_variant});
    }

    public IBlockState getVariantState(Variant var) {
        return this.func_176223_P().func_177226_a((IProperty)this.property_variant, (Comparable)var);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.property_variant, (Comparable)this.getVariants()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)state.func_177229_b((IProperty)this.property_variant)).id;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (Variant v : this.getVariants()) {
            list.add(new ItemStack(item, 1, v.id));
        }
    }

    @Override
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + ((Variant)this.func_176203_a((int)meta).func_177229_b((IProperty)this.property_variant)).material.suffix;
    }

    private class PropertyVariant
    extends PropertyHelper<Variant> {
        private Map<String, Variant> variants;

        public PropertyVariant(Variant[] variants) {
            super("metal", Variant.class);
            int i = 0;
            this.variants = new HashMap<String, Variant>();
            for (Variant v : variants) {
                v.id = i++;
                this.variants.put(v.func_176610_l(), v);
            }
        }

        public Collection<Variant> func_177700_c() {
            return this.variants.values();
        }

        public String getName(Variant value) {
            return value.func_176610_l();
        }

        public Optional<Variant> func_185929_b(String value) {
            return Optional.fromNullable((Object)this.variants.get(value));
        }
    }

    public static class Variant
    implements IStringSerializable,
    Comparable<Variant> {
        public final EnumMaterial material;
        public int id;

        public Variant(EnumMaterial material) {
            this.material = material;
            this.id = -1;
        }

        public String func_176610_l() {
            return this.material.suffix.toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }

        @Override
        public int compareTo(Variant o) {
            return this.id - o.id;
        }
    }
}

