/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.multiblock.solar;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.valkyrieofnight.environmentaltech.api.modifier.IModifierBlock;
import com.valkyrieofnight.environmentaltech.block.multiblock.solar.BlockSolar;
import com.valkyrieofnight.environmentaltech.modifier.ModifierHandler;
import com.valkyrieofnight.valkyrielib.energy.EnergyStorage;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class TileContSolarBase
extends VLTileController
implements IEnergyHandler,
IEnergyProvider {
    private List<BlockPos> solar_cells;
    private List<BlockPos> modifiers;
    private ModifierHandler modifierHandler;
    private boolean solarMode = false;
    private boolean piezoMode = false;
    private int tick = 0;
    private EnergyStorage eBuffer;
    private final int rft;

    public TileContSolarBase(int rft) {
        this.rft = rft;
        this.solar_cells = new ArrayList<BlockPos>();
        this.eBuffer = new EnergyStorage(this.getBaseDuration() * rft);
        this.modifiers = new ArrayList<BlockPos>();
        this.modifierHandler = new ModifierHandler();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tick;
            if (this.tick >= 60) {
                this.solarMode = true;
                this.piezoMode = true;
                for (BlockPos blockPos : this.solar_cells) {
                    if (this.field_145850_b.func_175710_j(blockPos.func_177972_a(EnumFacing.UP))) continue;
                    this.solarMode = false;
                    this.piezoMode = false;
                }
                if (!this.field_145850_b.func_72935_r()) {
                    this.solarMode = false;
                }
                if (!this.field_145850_b.func_72896_J()) {
                    this.piezoMode = false;
                }
                this.tick = 0;
            }
            this.handleEnergy();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.eBuffer.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eBuffer.readFromNBT(nbt);
    }

    public void handleEnergy() {
        for (EnumFacing facing : this.validEnergyDirections()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (!(te instanceof IEnergyReceiver)) continue;
            IEnergyReceiver er = (IEnergyReceiver)te;
            this.eBuffer.extractEnergy(er.receiveEnergy(facing.func_176734_d(), this.eBuffer.getEnergyStored(), false), false);
        }
    }

    public abstract EnumFacing[] validEnergyDirections();

    public boolean canProcess() {
        if (this.modifiers.isEmpty()) {
            this.modifiers = this.getStructure().getSlavesOfType(IModifierBlock.class, this.func_174877_v(), this.getMBDirectionE());
            ArrayList<IModifierBlock> mods = new ArrayList<IModifierBlock>();
            for (BlockPos mbp : this.modifiers) {
                Block blk = this.field_145850_b.func_180495_p(mbp).func_177230_c();
                if (!(blk instanceof IModifierBlock)) continue;
                mods.add((IModifierBlock)blk);
            }
            this.modifierHandler.setModifiers(mods);
            this.modifierHandler.calculateAttributeMultipliers();
        }
        if (this.solar_cells.isEmpty()) {
            this.solar_cells = this.getStructure().getSlavesOfType(BlockSolar.class, this.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection));
        }
        return this.solarMode || this.piezoMode;
    }

    public void deformMultiblock() {
        super.deformMultiblock();
        this.modifiers = new ArrayList<BlockPos>();
        this.modifierHandler = new ModifierHandler();
    }

    public void onProcessTick() {
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.eBuffer.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.eBuffer.getMaxEnergyStored();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.eBuffer.extractEnergy(maxExtract, simulate);
    }

    public void onProcessComplete() {
        int totalRF = 0;
        if (this.solarMode) {
            totalRF = (int)((float)totalRF + (float)this.rft * (float)this.getBaseDuration() * this.field_145850_b.getSunBrightnessFactor(1.0f));
        }
        if (this.piezoMode && this.modifierHandler.hasAttribute("piezo")) {
            totalRF = (int)((float)totalRF + (float)(this.rft / 64) * (float)this.getBaseDuration() * this.modifierHandler.getAttributeMultiplier("piezo") * this.field_145850_b.func_72867_j(1.0f));
        }
        this.eBuffer.receiveEnergy(totalRF, false);
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }
}

