/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.multiblock.lightning;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.valkyrieofnight.valkyrielib.energy.EnergyStorage;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileController;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public abstract class TileContLightningBase
extends VLTileController
implements IEnergyHandler,
IEnergyProvider {
    private boolean canGen = false;
    private int tick = 0;
    private EnergyStorage eBuffer;
    private final int rfPulse;
    private BlockPos rodTop;
    private Random rand = new Random();
    private int thisDuration = 0;

    public TileContLightningBase(int rfPulse) {
        this.rfPulse = rfPulse;
        this.eBuffer = new EnergyStorage(rfPulse * 4);
        this.thisDuration = MathHelper.func_76136_a((Random)new Random(), (int)(this.getDurationMax() / 2), (int)this.getDurationMax());
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.rodTop != null) {
                this.canGen = this.field_145850_b.func_72911_I();
            } else {
                this.canGen = false;
                int highestY = 0;
                for (BlockPos blockPos : this.getStructure().getSlavePositions(this.field_145850_b, this.func_174877_v(), this.getMBDirectionE())) {
                    if (blockPos.func_177956_o() <= highestY) continue;
                    highestY = blockPos.func_177956_o();
                    this.rodTop = blockPos;
                }
            }
            this.handleEnergy();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.eBuffer.writeToNBT(nbt);
        nbt.func_74768_a("thisDur", this.thisDuration);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eBuffer.readFromNBT(nbt);
        this.thisDuration = nbt.func_74762_e("thisDur");
    }

    public void handleEnergy() {
        for (EnumFacing facing : this.validEnergyDirections()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (!(te instanceof IEnergyReceiver)) continue;
            IEnergyReceiver er = (IEnergyReceiver)te;
            this.eBuffer.extractEnergy(er.receiveEnergy(facing.func_176734_d(), this.eBuffer.getEnergyStored(), false), false);
        }
    }

    public abstract EnumFacing[] validEnergyDirections();

    public boolean canProcess() {
        return this.canGen;
    }

    public void onProcessTick() {
    }

    public void onProcessComplete() {
        if (this.rand.nextInt(100) < this.getChance()) {
            BlockPos top = this.rodTop;
            this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)top.func_177958_n(), (double)top.func_177956_o(), (double)top.func_177952_p(), false));
            this.eBuffer.receiveEnergy(this.rfPulse, false);
        }
        this.thisDuration = MathHelper.func_76136_a((Random)new Random(), (int)(this.getDurationMax() / 4), (int)this.getDurationMax());
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public int getBaseDuration() {
        return this.thisDuration;
    }

    public abstract int getDurationMax();

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    public abstract int getChance();

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.eBuffer.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.eBuffer.getMaxEnergyStored();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.eBuffer.extractEnergy(maxExtract, simulate);
    }
}

