/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.machines.launcher;

import cofh.api.energy.IEnergyReceiver;
import com.valkyrieofnight.environmentaltech.network.PacketDispatcher;
import com.valkyrieofnight.environmentaltech.network.packets.launcher.LauncherPlayerLaunchPacket;
import com.valkyrieofnight.environmentaltech.network.packets.launcher.LauncherSettingsClientPacket;
import com.valkyrieofnight.environmentaltech.network.packets.launcher.LauncherSettingsServerPacket;
import com.valkyrieofnight.valkyrielib.block.facing.VLBlockFacing;
import com.valkyrieofnight.valkyrielib.energy.EnergyStorage;
import com.valkyrieofnight.valkyrielib.gui.IGuiHandlingObject;
import com.valkyrieofnight.valkyrielib.tileentity.VLTileEntity;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileLauncher
extends VLTileEntity
implements ITickable,
IEnergyReceiver,
IGuiHandlingObject {
    private EnergyStorage eBuffer = new EnergyStorage(100000);
    protected float forceNorthSouth;
    protected float forceEastWest = 0.0f;
    protected float forceUp = 0.0f;
    protected boolean requiredRedstone = false;
    protected boolean overrideVelocity = false;
    protected AxisAlignedBB motionBox;
    protected boolean updateServer = false;
    protected boolean updateClients = false;
    protected int tick;

    public void updateMotionBox() {
        IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (bs == null) {
            return;
        }
        BlockPos pos2 = this.field_174879_c;
        if (bs.func_177230_c() instanceof VLBlockFacing) {
            EnumFacing fac = ((VLBlockFacing)bs.func_177230_c()).getFacingFromState(bs);
            pos2 = this.field_174879_c.func_177972_a(fac);
        }
        this.motionBox = new AxisAlignedBB((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p(), (double)pos2.func_177958_n() + 1.0, (double)pos2.func_177956_o() + 1.0, (double)pos2.func_177952_p() + 1.0);
    }

    public void func_73660_a() {
        this.updateMotionBox();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tick;
            if (this.tick >= 40) {
                this.updateClients = true;
                this.tick = 0;
            }
            if (this.eBuffer.getEnergyStored() >= this.getRequiredEnergy()) {
                if (this.requiredRedstone) {
                    if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
                        this.runLauncher();
                    }
                } else {
                    this.runLauncher();
                }
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.updateServer) {
                this.updateServer = false;
                PacketDispatcher.DISPATCHER.sendToServer((IMessage)new LauncherSettingsServerPacket(this));
            }
        } else if (this.updateClients) {
            this.updateClients = false;
            PacketDispatcher.DISPATCHER.sendToAllAround((IMessage)new LauncherSettingsClientPacket(this), this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 8.0);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.eBuffer.writeToNBT(nbt);
        nbt.func_74776_a("forcens", this.forceNorthSouth);
        nbt.func_74776_a("forceew", this.forceEastWest);
        nbt.func_74776_a("forceup", this.forceUp);
        nbt.func_74757_a("requiresrs", this.requiredRedstone);
        nbt.func_74757_a("overridevel", this.overrideVelocity);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eBuffer.readFromNBT(nbt);
        this.forceNorthSouth = nbt.func_74760_g("forcens");
        this.forceEastWest = nbt.func_74760_g("forceew");
        this.forceUp = nbt.func_74760_g("forceup");
        this.requiredRedstone = nbt.func_74767_n("requiresrs");
        this.overrideVelocity = nbt.func_74767_n("overridevel");
        this.updateClients = true;
    }

    public void runLauncher() {
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.motionBox);
        for (EntityLivingBase en : entities) {
            if (this.overrideVelocity) {
                en.field_70159_w = this.forceEastWest;
                en.field_70181_x = this.forceUp;
                en.field_70179_y = this.forceNorthSouth;
            } else {
                en.field_70159_w += (double)this.forceEastWest;
                en.field_70181_x += (double)this.forceUp;
                en.field_70179_y += (double)this.forceNorthSouth;
            }
            if (en instanceof EntityPlayerMP) {
                this.updateClients = true;
                EntityPlayerMP ep = (EntityPlayerMP)en;
                PacketDispatcher.DISPATCHER.sendTo((IMessage)new LauncherPlayerLaunchPacket(this), ep);
                if (this.overrideVelocity) {
                    ep.func_70016_h((double)this.forceEastWest, (double)this.forceUp, (double)this.forceNorthSouth);
                } else {
                    ep.func_70024_g((double)this.forceEastWest, (double)this.forceUp, (double)this.forceNorthSouth);
                }
            }
            this.eBuffer.extractEnergy(this.getRequiredEnergy(), false);
        }
    }

    public void launchPlayer() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 3.0, (double)this.field_174879_c.func_177952_p() + 1.0);
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.motionBox);
        for (EntityLivingBase elb : entities) {
            if (!(elb instanceof EntityPlayer)) continue;
            if (this.overrideVelocity) {
                elb.func_70016_h((double)this.forceEastWest, (double)this.forceUp, (double)this.forceNorthSouth);
                continue;
            }
            elb.func_70024_g((double)this.forceEastWest, (double)this.forceUp, (double)this.forceNorthSouth);
        }
    }

    public int getRequiredEnergy() {
        int total = 0;
        total = (int)((float)total + MathHelper.func_76135_e((float)this.forceEastWest) * 800.0f);
        total = (int)((float)total + MathHelper.func_76135_e((float)this.forceNorthSouth) * 800.0f);
        total = (int)((float)total + MathHelper.func_76135_e((float)this.forceUp) * 800.0f);
        return total;
    }

    public abstract AxisAlignedBB getMotionBox();

    public abstract Class<? extends EntityLivingBase> getEntityType();

    public abstract float getForceUpMax();

    public abstract float getForceUpMin();

    public abstract float getForceNorthSouthMin();

    public abstract float getForceNorthSouthMax();

    public abstract float getForceEastWestMin();

    public abstract float getForceEastWestMax();

    public void updateClients() {
        this.updateClients = true;
    }

    public void setForceNorthSouth(float force) {
        this.updateServer = true;
        float tmp = Math.max(Math.min(force, this.getForceNorthSouthMax()), this.getForceNorthSouthMin());
        this.forceNorthSouth = (float)((double)Math.round((double)tmp * 100.0) / 100.0);
    }

    public void setForceEastWest(float force) {
        this.updateServer = true;
        float tmp = Math.max(Math.min(force, this.getForceEastWestMax()), this.getForceEastWestMin());
        this.forceEastWest = (float)((double)Math.round((double)tmp * 100.0) / 100.0);
    }

    public void setForceUp(float force) {
        this.updateServer = true;
        float tmp = Math.max(Math.min(force, this.getForceUpMax()), this.getForceUpMin());
        this.forceUp = (float)((double)Math.round((double)tmp * 100.0) / 100.0);
    }

    public float getForceNorthSouth() {
        return this.forceNorthSouth;
    }

    public float getForceEastWest() {
        return this.forceEastWest;
    }

    public float getForceUp() {
        return this.forceUp;
    }

    public boolean getRequiresRedstone() {
        return this.requiredRedstone;
    }

    public void setRequiresRestone(boolean opt) {
        this.updateServer = true;
        this.requiredRedstone = opt;
    }

    public boolean getOverrideVelocity() {
        return this.overrideVelocity;
    }

    public void setOverrideVelocity(boolean opt) {
        this.updateServer = true;
        this.overrideVelocity = opt;
    }

    public boolean isMaxNorthForce() {
        if (this.forceNorthSouth >= this.getForceNorthSouthMax()) {
            this.forceNorthSouth = this.getForceNorthSouthMax();
            return true;
        }
        return false;
    }

    public boolean isMaxSouthForce() {
        if (this.forceNorthSouth <= this.getForceNorthSouthMin()) {
            this.forceNorthSouth = this.getForceNorthSouthMin();
            return true;
        }
        return false;
    }

    public boolean isMaxEastForce() {
        if (this.forceEastWest >= this.getForceEastWestMax()) {
            this.forceEastWest = this.getForceEastWestMax();
            return true;
        }
        return false;
    }

    public boolean isMaxWestForce() {
        if (this.forceEastWest <= this.getForceEastWestMin()) {
            this.forceEastWest = this.getForceEastWestMin();
            return true;
        }
        return false;
    }

    public boolean isMaxUpForce() {
        if (this.forceUp >= this.getForceUpMax()) {
            this.forceUp = this.getForceUpMax();
            return true;
        }
        return false;
    }

    public boolean isMinUpForce() {
        if (this.forceUp <= this.getForceUpMin()) {
            this.forceUp = this.getForceUpMin();
            return true;
        }
        return false;
    }

    public void updateEnergyStored(int en) {
        this.eBuffer.setEnergyStored(en);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.eBuffer.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.eBuffer.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return from != EnumFacing.UP;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return from != EnumFacing.UP ? this.eBuffer.receiveEnergy(maxReceive, simulate) : 0;
    }

    public float getEnergyScale() {
        return (float)this.eBuffer.getEnergyStored() / (float)this.eBuffer.getMaxEnergyStored();
    }
}

