/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.modifier;

import com.valkyrieofnight.environmentaltech.api.modifier.IModifierAttribute;
import com.valkyrieofnight.environmentaltech.api.modifier.IModifierBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ModifierHandler {
    private List<IModifierBlock> modifiers = new ArrayList<IModifierBlock>();
    private HashMap<String, Float> attributeTotals = new HashMap();
    private boolean hasCalculated = false;

    public void setModifiers(List<IModifierBlock> modifiers) {
        this.modifiers = modifiers;
    }

    public void calculateAttributeMultipliers() {
        HashMap<String, Float> attributeFactors = new HashMap<String, Float>();
        HashMap<String, IModifierAttribute> baseAttributes = new HashMap<String, IModifierAttribute>();
        for (IModifierBlock mod : this.modifiers) {
            List<IModifierAttribute> attributes = mod.getAttributes();
            if (attributes == null) continue;
            for (IModifierAttribute attr : attributes) {
                boolean hasAttribute = false;
                for (String atF : attributeFactors.keySet()) {
                    if (!atF.equalsIgnoreCase(attr.getAttributeName())) continue;
                    hasAttribute = true;
                }
                float currFactor = 0.0f;
                if (hasAttribute) {
                    currFactor = ((Float)attributeFactors.get(attr.getAttributeName())).floatValue();
                } else {
                    baseAttributes.put(attr.getAttributeName(), attr);
                }
                attributeFactors.put(attr.getAttributeName(), Float.valueOf(currFactor += attr.getModificationFactor()));
            }
        }
        for (String fact : attributeFactors.keySet()) {
            IModifierAttribute ma = (IModifierAttribute)baseAttributes.get(fact);
            this.attributeTotals.put(fact, Float.valueOf(ma.getMultiplier(((Float)attributeFactors.get(fact)).floatValue())));
        }
    }

    public boolean hasAttribute(String attributeName) {
        for (String modName : this.attributeTotals.keySet()) {
            if (!attributeName.equalsIgnoreCase(modName)) continue;
            return true;
        }
        return false;
    }

    public float getAttributeMultiplier(String attributeName) {
        for (String modName : this.attributeTotals.keySet()) {
            if (!attributeName.equalsIgnoreCase(modName)) continue;
            return this.attributeTotals.get(modName).floatValue();
        }
        return 1.0f;
    }
}

