/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.init;

import com.valkyrieofnight.environmentaltech.api.registry.ETRegistries;
import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.api.util.WeightedItemStack;
import com.valkyrieofnight.environmentaltech.api.util.WeightedOreStack;
import com.valkyrieofnight.environmentaltech.init.ETBlocks;
import com.valkyrieofnight.environmentaltech.init.ETItems;
import com.valkyrieofnight.environmentaltech.registry.terraformer.TerraformerSoftwareRegistry;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwareDeforrest;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwareGrassGrower;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwarePlantRemover;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class ETCommonRecipes {
    private static ETBlocks etb;
    private static ETItems eti;
    private static TerraformerSoftwareRegistry tfr;

    public static void preInit() {
        tfr.registerSoftware(SoftwareDeforrest.getInstance());
        tfr.registerSoftware(SoftwarePlantRemover.getInstance());
        tfr.registerSoftware(SoftwareGrassGrower.getInstance());
    }

    public static void initialize() {
    }

    public static void postInit() {
        ETCommonRecipes.addVoidOreMinerRecipes();
        ETCommonRecipes.addVoidResMinerRecipes();
    }

    public static void addVoidOreMinerRecipes() {
        IFocusableRegistry reg = ETRegistries.voidOreMinerRegistry;
        reg.addResource(new WeightedOreStack("oreCoal", 32), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreIron", 28), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreQuartz", 16), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreRedstone", 18), EnumDyeColor.RED);
        reg.addResource(new WeightedOreStack("oreLapis", 18), EnumDyeColor.BLUE);
        reg.addResource(new WeightedOreStack("oreGold", 14), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedOreStack("oreDiamond", 10), EnumDyeColor.CYAN);
        reg.addResource(new WeightedOreStack("oreEmerald", 4), EnumDyeColor.LIME);
        reg.addResource(new WeightedOreStack("glowstone", 6), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedOreStack("shardLonsdaleite", 5), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreCopper", 26), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreTin", 26), EnumDyeColor.GRAY);
        reg.addResource(new WeightedOreStack("oreSilver", 20), EnumDyeColor.SILVER);
        reg.addResource(new WeightedOreStack("oreLead", 22), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedOreStack("oreAluminum", 20), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreUranium", 10), EnumDyeColor.GREEN);
        reg.addResource(new WeightedOreStack("oreYellorite", 10), EnumDyeColor.GREEN);
        reg.addResource(new WeightedOreStack("oreCertusQuartz", 8), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreChargedCertusQuartz", 4), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreCinnabar", 12), EnumDyeColor.BROWN);
        reg.addResource(new WeightedOreStack("oreAmber", 10), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreNickel", 10), EnumDyeColor.GRAY);
        reg.addResource(new WeightedOreStack("orePlatinum", 6), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreMithril", 6), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreSulfur", 10), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedOreStack("oreNiter", 10), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreSaltpeter", 8), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreFirestone", 6), EnumDyeColor.RED);
        reg.addResource(new WeightedOreStack("oreCobalt", 8), EnumDyeColor.BLUE);
        reg.addResource(new WeightedOreStack("oreArdite", 8), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreApatite", 10), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreDraconium", 6), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedOreStack("oreGraphite", 14), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreQuartzBlack", 14), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreRuby", 10), EnumDyeColor.RED);
        reg.addResource(new WeightedOreStack("orePeridot", 10), EnumDyeColor.GREEN);
        reg.addResource(new WeightedOreStack("oreTopaz", 10), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreTanzanite", 10), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedOreStack("oreMalachite", 10), EnumDyeColor.CYAN);
        reg.addResource(new WeightedOreStack("oreSapphire", 10), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreResonating", 10), EnumDyeColor.BROWN);
        reg.addResource(new WeightedOreStack("oreZinc", 10), EnumDyeColor.PINK);
        reg.addResource(new WeightedOreStack("oreIridium", 6), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreTungsten", 8), EnumDyeColor.BLACK);
    }

    public static void addVoidResMinerRecipes() {
        IFocusableRegistry reg = ETRegistries.voidResMinerRegistry;
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 0), 16), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 1), 14), EnumDyeColor.PINK);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 3), 14), EnumDyeColor.WHITE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 5), 14), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150351_n, 1, 0), 14), EnumDyeColor.SILVER);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150349_c, 1, 0), 6), EnumDyeColor.GREEN);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150346_d, 1, 0), 14), EnumDyeColor.BROWN);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150346_d, 1, 2), 6), EnumDyeColor.BROWN);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150354_m, 1, 0), 14), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150354_m, 1, 1), 10), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150347_e, 1, 0), 14), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150341_Y, 1, 0), 6), EnumDyeColor.GREEN);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150343_Z, 1, 0), 5), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150435_aG, 1, 0), 7), EnumDyeColor.SILVER);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150424_aL, 1, 0), 14), EnumDyeColor.RED);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150425_aM, 1, 0), 10), EnumDyeColor.BROWN);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150391_bh, 1, 0), 4), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150377_bs, 1, 0), 7), EnumDyeColor.WHITE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150405_ch, 1, 0), 6), EnumDyeColor.RED);
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150406_ce, 1, dye.func_176765_a()), 1), dye);
        }
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150360_v, 1, 0), 2), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.alabaster, 1, 0), 10), EnumDyeColor.WHITE);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.basalt, 1, 0), 10), EnumDyeColor.BLACK);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.hardened_stone, 1, 0), 10), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.mica, 1), 2), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("stoneMarble", 10), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("stoneLimestone", 10), EnumDyeColor.LIME);
    }

    static {
        tfr = TerraformerSoftwareRegistry.getInstance();
    }
}

