/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.core;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ETConfig {
    private static String CONFIG_LOC = "config/environmentaltech/";
    private static Configuration oreConfig;
    private static File oldOreFileLocation;
    private static File oregenConfigFile;
    private static File worldgenConfigFile;
    public static EnumRecipeSet RECIPE_SET;
    public static boolean enableHardenedStoneGeneration;
    public static int hardenedStoneNodes;
    public static int hardenedStoneNodeSize;
    public static int hardenedStoneMinHeight;
    public static int hardenedStoneMaxHeight;
    public static boolean enableAlabasterGeneration;
    public static int alabasterNodes;
    public static int alabasterNodeSize;
    public static int alabasterMinHeight;
    public static int alabasterMaxHeight;
    public static boolean enableBasaltGeneration;
    public static int basaltNodes;
    public static int basaltNodeSize;
    public static int basaltMinHeight;
    public static int basaltMaxHeight;
    private static File clientConfigFile;
    private static Configuration clientConfig;
    public static boolean enableBeamPulse;
    private static File machineConfigFile;
    private static Configuration machineConfig;

    public static void preInit() {
        ETConfig.loadOreConfig();
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ETConfig.loadClientConfig();
    }

    @SideOnly(value=Side.CLIENT)
    private static void loadClientConfig() {
        clientConfig = new Configuration(clientConfigFile);
        if (clientConfigFile.exists()) {
            clientConfig.load();
        }
        enableBeamPulse = clientConfig.getBoolean("PulsatingBeam", "Void_Miners", enableBeamPulse, "This will cause the beam to only render when machine is mining. Can flicker fast when machine has speed modifiers. By default it renders when the machine is constructed correctly");
        if (!clientConfigFile.exists() || clientConfig.hasChanged()) {
            clientConfig.save();
        }
    }

    private static void loadOreConfig() {
        if (!worldgenConfigFile.exists() && oldOreFileLocation.exists()) {
            oldOreFileLocation.renameTo(worldgenConfigFile);
        }
        if (!worldgenConfigFile.exists() && oregenConfigFile.exists()) {
            oregenConfigFile.renameTo(worldgenConfigFile);
        }
        oreConfig = new Configuration(worldgenConfigFile);
        if (worldgenConfigFile.exists()) {
            oreConfig.load();
        }
        RECIPE_SET = EnumRecipeSet.SIMPLE;
        enableHardenedStoneGeneration = oreConfig.getBoolean("genHardenedStone", "WorldGen", true, "Enables Generation of Hardened Stone between world heighs of: 0 and 12");
        hardenedStoneNodes = oreConfig.getInt("hardenedStoneTotalNodes", "WorldGen", hardenedStoneNodes, 0, 32, "Total spawns of Hardened Stone in each chunk");
        hardenedStoneNodeSize = oreConfig.getInt("hardenedStoneNodeSize", "WorldGen", hardenedStoneNodeSize, 0, 128, "Size of each spawn of Hardened Stone");
        hardenedStoneMinHeight = oreConfig.getInt("hardenedStoneMinHeight", "WorldGen", hardenedStoneMinHeight, 0, 64, "Min height of Hardened Stone");
        hardenedStoneMaxHeight = oreConfig.getInt("hardenedStoneMaxHeight", "WorldGen", hardenedStoneMaxHeight, 0, 255, "Max height of Hardened Stone");
        hardenedStoneMinHeight = Math.min(64, Math.max(hardenedStoneMinHeight, 0));
        hardenedStoneMaxHeight = Math.max(0, Math.min(hardenedStoneMaxHeight, 255));
        enableAlabasterGeneration = oreConfig.getBoolean("genAlabaster", "WorldGen", true, "Enables Generation of Alabaster between world heighs of: 44 and 200");
        alabasterNodes = oreConfig.getInt("alabasterTotalNodes", "WorldGen", alabasterNodes, 0, 32, "Total spawns of Alabaster in each chunk");
        alabasterNodeSize = oreConfig.getInt("alabasterNodeSize", "WorldGen", alabasterNodeSize, 0, 64, "Size of each spawn of Alabaster");
        alabasterMinHeight = oreConfig.getInt("alabasterMinHeight", "WorldGen", alabasterMinHeight, 0, 64, "Min height of Alabaster");
        alabasterMaxHeight = oreConfig.getInt("alabasterMaxHeight", "WorldGen", alabasterMaxHeight, 0, 255, "Max height of Alabaster");
        alabasterMinHeight = Math.min(64, Math.max(alabasterMinHeight, 0));
        alabasterMaxHeight = Math.max(0, Math.min(alabasterMaxHeight, 255));
        enableBasaltGeneration = oreConfig.getBoolean("genBasalt", "WorldGen", true, "Enables Generation of Basalt between world heighs of: 8 and 32");
        basaltNodes = oreConfig.getInt("basaltTotalNodes", "WorldGen", basaltNodes, 0, 32, "Total spawns of Basalt in each chunk");
        basaltNodeSize = oreConfig.getInt("basaltNodeSize", "WorldGen", basaltNodeSize, 0, 64, "Size of each spawn of Basalt");
        basaltMinHeight = oreConfig.getInt("basaltMinHeight", "WorldGen", basaltMinHeight, 0, 64, "Min height of Basalt");
        basaltMaxHeight = oreConfig.getInt("basaltMaxHeight", "WorldGen", basaltMaxHeight, 0, 255, "Max height of Basalt");
        basaltMinHeight = Math.min(64, Math.max(basaltMinHeight, 0));
        basaltMaxHeight = Math.max(0, Math.min(basaltMaxHeight, 255));
        if (!worldgenConfigFile.exists() || oreConfig.hasChanged()) {
            oreConfig.save();
        }
    }

    static {
        oldOreFileLocation = new File("config/environmentaltech.cfg");
        oregenConfigFile = new File(CONFIG_LOC + "ores.cfg");
        worldgenConfigFile = new File(CONFIG_LOC + "worldgen.cfg");
        hardenedStoneNodes = 12;
        hardenedStoneNodeSize = 30;
        hardenedStoneMinHeight = 0;
        hardenedStoneMaxHeight = 12;
        alabasterNodes = 22;
        alabasterNodeSize = 30;
        alabasterMinHeight = 40;
        alabasterMaxHeight = 200;
        basaltNodes = 14;
        basaltNodeSize = 28;
        basaltMinHeight = 8;
        basaltMaxHeight = 32;
        clientConfigFile = new File(CONFIG_LOC + "client.cfg");
        enableBeamPulse = false;
        machineConfigFile = new File(CONFIG_LOC + "machines.cfg");
    }

    public static enum EnumRecipeSet {
        SIMPLE,
        ADVANCED;

    }
}

