/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.client.integration.jei.focusable;

import com.google.common.collect.ImmutableList;
import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.api.util.WeightedStackBase;
import com.valkyrieofnight.environmentaltech.init.ETBlocks;
import com.valkyrieofnight.valkyrielib.util.helpers.LanguageHelper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fluids.FluidStack;

public abstract class FocusableRecipeWrapper
implements IRecipeWrapper {
    private final List<ItemStack> input;
    private final WeightedStackBase output;
    public final float clearLens;
    public float prefLens = 0.0f;

    protected FocusableRecipeWrapper(WeightedStackBase stack) {
        this.output = stack;
        this.input = new ArrayList<ItemStack>();
        this.input.add(new ItemStack((Block)ETBlocks.lens));
        this.input.add(new ItemStack((Block)ETBlocks.lens_colored, 1, this.getRegistry().getPrioritizedLens(stack.getMainStack()).func_176765_a()));
        EnumDyeColor dye = this.getRegistry().getPrioritizedLens(stack.getMainStack());
        List<WeightedStackBase> fList = this.getRegistry().getFocusedList(dye, 1.0f);
        for (WeightedStackBase weightedOreItemStack : fList) {
            if (!weightedOreItemStack.isStackEqual(stack.getMainStack())) continue;
            WeightedStackBase temp = weightedOreItemStack;
            this.prefLens = (float)Math.round((float)weightedOreItemStack.getWeight() / (float)WeightedRandom.func_76272_a(fList) * 10000.0f) / 100.0f;
            break;
        }
        this.clearLens = (float)Math.round((float)stack.getWeight() / (float)WeightedRandom.func_76272_a(this.getRegistry().getUnFocusedList()) * 10000.0f) / 100.0f;
    }

    public abstract IFocusableRegistry getRegistry();

    public List<ItemStack> getInputs() {
        return this.input;
    }

    public List getOutputs() {
        return ImmutableList.of((Object)this.output.getMainStack());
    }

    public List<FluidStack> getFluidInputs() {
        return ImmutableList.of();
    }

    public List<FluidStack> getFluidOutputs() {
        return ImmutableList.of();
    }

    public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String lens = LanguageHelper.toLoc((String)"gui.environmentaltech.lens");
        int lensW = minecraft.field_71466_p.func_78256_a(lens);
        String clear = LanguageHelper.toLoc((String)"gui.environmentaltech.clear");
        int clearfW = minecraft.field_71466_p.func_78256_a(clear);
        String perf = LanguageHelper.toLoc((String)"gui.environmentaltech.pref");
        int perfW = minecraft.field_71466_p.func_78256_a(perf);
        String clearPerc = this.clearLens + "%";
        int clearPW = minecraft.field_71466_p.func_78256_a(clearPerc);
        String prefPerc = this.prefLens + "%";
        int prefPW = minecraft.field_71466_p.func_78256_a(prefPerc);
        minecraft.field_71466_p.func_78276_b(clear, 15 - clearfW / 2, 0, EnumDyeColor.BLACK.func_176768_e().field_76291_p);
        minecraft.field_71466_p.func_78276_b(clearPerc, 15 - clearPW / 2, 40, EnumDyeColor.BLACK.func_176768_e().field_76291_p);
        minecraft.field_71466_p.func_78276_b(perf, 113 - perfW / 2, 0, EnumDyeColor.BLACK.func_176768_e().field_76291_p);
        minecraft.field_71466_p.func_78276_b(prefPerc, 113 - prefPW / 2, 40, EnumDyeColor.BLACK.func_176768_e().field_76291_p);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return ImmutableList.of();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

